/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.provider;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.gen.js.JsInvokeProtos;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.TbQueueRequestTemplate;
import org.thingsboard.server.queue.common.DefaultTbQueueRequestTemplate;
import org.thingsboard.server.queue.common.TbProtoJsQueueMsg;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.edqs.EdqsConfig;
import org.thingsboard.server.queue.memory.InMemoryStorage;
import org.thingsboard.server.queue.memory.InMemoryTbQueueConsumer;
import org.thingsboard.server.queue.memory.InMemoryTbQueueProducer;
import org.thingsboard.server.queue.provider.TbCoreQueueFactory;
import org.thingsboard.server.queue.provider.TbRuleEngineQueueFactory;
import org.thingsboard.server.queue.provider.TbVersionControlQueueFactory;
import org.thingsboard.server.queue.settings.TasksQueueConfig;
import org.thingsboard.server.queue.settings.TbQueueCalculatedFieldSettings;
import org.thingsboard.server.queue.settings.TbQueueCoreSettings;
import org.thingsboard.server.queue.settings.TbQueueEdgeSettings;
import org.thingsboard.server.queue.settings.TbQueueRuleEngineSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportApiSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportNotificationSettings;
import org.thingsboard.server.queue.settings.TbQueueVersionControlSettings;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='in-memory' && '${service.type:null}'=='monolith'")
public class InMemoryMonolithQueueFactory
implements TbCoreQueueFactory,
TbRuleEngineQueueFactory,
TbVersionControlQueueFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryMonolithQueueFactory.class);
    private final TopicService topicService;
    private final TbQueueCoreSettings coreSettings;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TbQueueAdmin queueAdmin;
    private final TbQueueRuleEngineSettings ruleEngineSettings;
    private final TbQueueVersionControlSettings vcSettings;
    private final TbQueueTransportApiSettings transportApiSettings;
    private final TbQueueTransportNotificationSettings transportNotificationSettings;
    private final TbQueueEdgeSettings edgeSettings;
    private final TbQueueCalculatedFieldSettings calculatedFieldSettings;
    private final EdqsConfig edqsConfig;
    private final TasksQueueConfig tasksQueueConfig;
    private final InMemoryStorage storage;

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> createTransportNotificationsMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>>(this.storage, this.topicService.buildTopicName(this.transportNotificationSettings.getNotificationsTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> createRuleEngineMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>>(this.storage, this.topicService.buildTopicName(this.ruleEngineSettings.getTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>> createRuleEngineNotificationsMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>>(this.storage, this.topicService.buildTopicName(this.ruleEngineSettings.getTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> createTbCoreMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>>(this.storage, this.topicService.buildTopicName(this.coreSettings.getTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>> createTbCoreNotificationsMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>>(this.storage, this.topicService.getNotificationsTopic(ServiceType.TB_CORE, this.serviceInfoProvider.getServiceId()).getFullTopicName());
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToVersionControlServiceMsg>> createToVersionControlMsgConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToVersionControlServiceMsg>>(this.storage, this.topicService.buildTopicName(this.vcSettings.getTopic()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> createToRuleEngineMsgConsumer(Queue configuration) {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>>(this.storage, this.topicService.buildTopicName(configuration.getTopic()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>> createToRuleEngineNotificationsMsgConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>>(this.storage, this.topicService.getNotificationsTopic(ServiceType.TB_RULE_ENGINE, this.serviceInfoProvider.getServiceId()).getFullTopicName());
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> createToCoreMsgConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>>(this.storage, this.topicService.buildTopicName(this.coreSettings.getTopic()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>> createToCoreNotificationsMsgConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>>(this.storage, this.topicService.getNotificationsTopic(ServiceType.TB_CORE, this.serviceInfoProvider.getServiceId()).getFullTopicName());
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>> createTransportApiRequestConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>>(this.storage, this.topicService.buildTopicName(this.transportApiSettings.getRequestsTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>> createTransportApiResponseProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>>(this.storage, this.topicService.buildTopicName(this.transportApiSettings.getResponsesTopic()));
    }

    @Override
    public TbQueueRequestTemplate<TbProtoJsQueueMsg<JsInvokeProtos.RemoteJsRequest>, TbProtoQueueMsg<JsInvokeProtos.RemoteJsResponse>> createRemoteJsRequestTemplate() {
        return null;
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldMsg>> createToCalculatedFieldMsgConsumer(TopicPartitionInfo tpi) {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldMsg>>(this.storage, this.topicService.buildTopicName(this.calculatedFieldSettings.getEventTopic()));
    }

    @Override
    public TbQueueAdmin getCalculatedFieldQueueAdmin() {
        return this.queueAdmin;
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldMsg>> createToCalculatedFieldMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldMsg>>(this.storage, this.topicService.buildTopicName(this.calculatedFieldSettings.getEventTopic()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldNotificationMsg>> createToCalculatedFieldNotificationMsgConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldNotificationMsg>>(this.storage, this.topicService.getCalculatedFieldNotificationsTopic(this.serviceInfoProvider.getServiceId()).getFullTopicName());
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.CalculatedFieldStateProto>> createCalculatedFieldStateConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.CalculatedFieldStateProto>>(this.storage, this.topicService.buildTopicName(this.calculatedFieldSettings.getStateTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.CalculatedFieldStateProto>> createCalculatedFieldStateProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.CalculatedFieldStateProto>>(this.storage, this.topicService.buildTopicName(this.calculatedFieldSettings.getStateTopic()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> createToUsageStatsServiceMsgConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>>(this.storage, this.topicService.buildTopicName(this.coreSettings.getUsageStatsTopic()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>> createToOtaPackageStateServiceMsgConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>>(this.storage, this.topicService.buildTopicName(this.coreSettings.getOtaPackageTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>> createToOtaPackageStateServiceMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>>(this.storage, this.topicService.buildTopicName(this.coreSettings.getOtaPackageTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> createToUsageStatsServiceMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>>(this.storage, this.topicService.buildTopicName(this.coreSettings.getUsageStatsTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToVersionControlServiceMsg>> createVersionControlMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToVersionControlServiceMsg>>(this.storage, this.topicService.buildTopicName(this.vcSettings.getTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>> createHousekeeperMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>>(this.storage, this.topicService.buildTopicName(this.coreSettings.getHousekeeperTopic()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>> createHousekeeperMsgConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>>(this.storage, this.topicService.buildTopicName(this.coreSettings.getHousekeeperTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>> createHousekeeperReprocessingMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>>(this.storage, this.topicService.buildTopicName(this.coreSettings.getHousekeeperReprocessingTopic()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>> createHousekeeperReprocessingMsgConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>>(this.storage, this.topicService.buildTopicName(this.coreSettings.getHousekeeperReprocessingTopic()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToEdgeMsg>> createEdgeMsgConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToEdgeMsg>>(this.storage, this.topicService.buildTopicName(this.edgeSettings.getTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToEdgeMsg>> createEdgeMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToEdgeMsg>>(this.storage, this.topicService.buildTopicName(this.edgeSettings.getTopic()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToEdgeNotificationMsg>> createToEdgeNotificationsMsgConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToEdgeNotificationMsg>>(this.storage, this.topicService.getEdgeNotificationsTopic(this.serviceInfoProvider.getServiceId()).getFullTopicName());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToEdgeNotificationMsg>> createEdgeNotificationsMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToEdgeNotificationMsg>>(this.storage, this.topicService.getEdgeNotificationsTopic(this.serviceInfoProvider.getServiceId()).getFullTopicName());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToEdgeEventNotificationMsg>> createEdgeEventMsgProducer() {
        return null;
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldNotificationMsg>> createToCalculatedFieldNotificationMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldNotificationMsg>>(this.storage, this.topicService.buildTopicName(this.calculatedFieldSettings.getEventTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToEdqsMsg>> createEdqsEventsProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToEdqsMsg>>(this.storage, this.edqsConfig.getEventsTopic());
    }

    @Override
    public TbQueueRequestTemplate<TbProtoQueueMsg<TransportProtos.ToEdqsMsg>, TbProtoQueueMsg<TransportProtos.FromEdqsMsg>> createEdqsRequestTemplate() {
        InMemoryTbQueueProducer requestProducer = new InMemoryTbQueueProducer(this.storage, this.edqsConfig.getRequestsTopic());
        InMemoryTbQueueConsumer responseConsumer = new InMemoryTbQueueConsumer(this.storage, this.edqsConfig.getResponsesTopic());
        return DefaultTbQueueRequestTemplate.builder().queueAdmin(this.queueAdmin).requestTemplate(requestProducer).responseTemplate(responseConsumer).maxPendingRequests(this.edqsConfig.getMaxPendingRequests()).maxRequestTimeout(this.edqsConfig.getMaxRequestTimeout()).pollInterval(this.edqsConfig.getPollInterval()).build();
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.JobStatsMsg>> createJobStatsConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.JobStatsMsg>>(this.storage, this.tasksQueueConfig.getStatsTopic());
    }

    @Scheduled(fixedRateString="${queue.in_memory.stats.print-interval-ms:60000}")
    private void printInMemoryStats() {
        this.storage.printStats();
    }

    @ConstructorProperties(value={"topicService", "coreSettings", "serviceInfoProvider", "queueAdmin", "ruleEngineSettings", "vcSettings", "transportApiSettings", "transportNotificationSettings", "edgeSettings", "calculatedFieldSettings", "edqsConfig", "tasksQueueConfig", "storage"})
    @Generated
    public InMemoryMonolithQueueFactory(TopicService topicService, TbQueueCoreSettings coreSettings, TbServiceInfoProvider serviceInfoProvider, TbQueueAdmin queueAdmin, TbQueueRuleEngineSettings ruleEngineSettings, TbQueueVersionControlSettings vcSettings, TbQueueTransportApiSettings transportApiSettings, TbQueueTransportNotificationSettings transportNotificationSettings, TbQueueEdgeSettings edgeSettings, TbQueueCalculatedFieldSettings calculatedFieldSettings, EdqsConfig edqsConfig, TasksQueueConfig tasksQueueConfig, InMemoryStorage storage) {
        this.topicService = topicService;
        this.coreSettings = coreSettings;
        this.serviceInfoProvider = serviceInfoProvider;
        this.queueAdmin = queueAdmin;
        this.ruleEngineSettings = ruleEngineSettings;
        this.vcSettings = vcSettings;
        this.transportApiSettings = transportApiSettings;
        this.transportNotificationSettings = transportNotificationSettings;
        this.edgeSettings = edgeSettings;
        this.calculatedFieldSettings = calculatedFieldSettings;
        this.edqsConfig = edqsConfig;
        this.tasksQueueConfig = tasksQueueConfig;
        this.storage = storage;
    }
}

