/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.notification;

import com.google.protobuf.ByteString;
import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.JavaSerDesUtil;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.msg.notification.NotificationRuleProcessor;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.notification.NotificationDeduplicationService;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;

@Service
@ConditionalOnMissingBean(value={NotificationRuleProcessor.class}, ignored={RemoteNotificationRuleProcessor.class})
public class RemoteNotificationRuleProcessor
implements NotificationRuleProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoteNotificationRuleProcessor.class);
    private final NotificationDeduplicationService deduplicationService;
    private final TbQueueProducerProvider producerProvider;
    private final TopicService topicService;
    private final PartitionService partitionService;

    public void process(NotificationRuleTrigger trigger) {
        try {
            if (!NotificationRuleTrigger.DeduplicationStrategy.NONE.equals((Object)trigger.getDeduplicationStrategy()) && this.deduplicationService.alreadyProcessed(trigger)) {
                return;
            }
            log.debug("Submitting notification rule trigger: {}", (Object)trigger);
            TransportProtos.NotificationRuleProcessorMsg.Builder msg = TransportProtos.NotificationRuleProcessorMsg.newBuilder().setTrigger(ByteString.copyFrom((byte[])JavaSerDesUtil.encode((Object)trigger)));
            this.partitionService.getAllServiceIds(ServiceType.TB_CORE).stream().findAny().ifPresent(serviceId -> {
                TopicPartitionInfo tpi = this.topicService.getNotificationsTopic(ServiceType.TB_CORE, (String)serviceId);
                this.producerProvider.getTbCoreNotificationsMsgProducer().send(tpi, new TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>(UUID.randomUUID(), TransportProtos.ToCoreNotificationMsg.newBuilder().setNotificationRuleProcessorMsg(msg).build()), null);
            });
        }
        catch (Throwable e) {
            log.error("Failed to submit notification rule trigger: {}", (Object)trigger, (Object)e);
        }
    }

    @ConstructorProperties(value={"deduplicationService", "producerProvider", "topicService", "partitionService"})
    @Generated
    public RemoteNotificationRuleProcessor(NotificationDeduplicationService deduplicationService, TbQueueProducerProvider producerProvider, TopicService topicService, PartitionService partitionService) {
        this.deduplicationService = deduplicationService;
        this.producerProvider = producerProvider;
        this.topicService = topicService;
        this.partitionService = partitionService;
    }
}

