/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.notification;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.thingsboard.server.common.data.notification.rule.NotificationRule;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.queue.notification.NotificationDeduplicationService;
import org.thingsboard.server.queue.util.PropertyUtils;

@Service
public class DefaultNotificationDeduplicationService
implements NotificationDeduplicationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultNotificationDeduplicationService.class);
    private ConcurrentMap<NotificationRuleTriggerType, Long> deduplicationDurations;
    @Autowired(required=false)
    private CacheManager cacheManager;
    private final ConcurrentMap<String, Long> localCache = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    @Override
    public boolean alreadyProcessed(NotificationRuleTrigger trigger) {
        String deduplicationKey = trigger.getDeduplicationKey();
        return this.alreadyProcessed(trigger, deduplicationKey, true);
    }

    @Override
    public boolean alreadyProcessed(NotificationRuleTrigger trigger, NotificationRule rule) {
        String deduplicationKey = DefaultNotificationDeduplicationService.getDeduplicationKey(trigger, rule);
        return this.alreadyProcessed(trigger, deduplicationKey, false);
    }

    private boolean alreadyProcessed(NotificationRuleTrigger trigger, String deduplicationKey, boolean onlyLocalCache) {
        Cache externalCache;
        Long lastProcessedTs = (Long)this.localCache.get(deduplicationKey);
        if (lastProcessedTs == null && !onlyLocalCache) {
            Cache externalCache2 = this.getExternalCache();
            if (externalCache2 != null) {
                lastProcessedTs = (Long)externalCache2.get((Object)deduplicationKey, Long.class);
            } else {
                log.warn("Sent notifications cache is not set up");
            }
        }
        boolean alreadyProcessed = false;
        long deduplicationDuration = this.getDeduplicationDuration(trigger);
        if (lastProcessedTs != null) {
            long passed = System.currentTimeMillis() - lastProcessedTs;
            log.trace("Deduplicating trigger {} by key '{}'. Deduplication duration: {} ms, passed: {} ms", new Object[]{trigger.getType(), deduplicationKey, deduplicationDuration, passed});
            if (deduplicationDuration == 0L || passed <= deduplicationDuration) {
                alreadyProcessed = true;
            }
        }
        if (!alreadyProcessed) {
            lastProcessedTs = System.currentTimeMillis();
        }
        this.localCache.put(deduplicationKey, lastProcessedTs);
        if (!(onlyLocalCache || alreadyProcessed && deduplicationDuration != 0L || (externalCache = this.getExternalCache()) == null)) {
            externalCache.put((Object)deduplicationKey, (Object)lastProcessedTs);
        }
        return alreadyProcessed;
    }

    public static String getDeduplicationKey(NotificationRuleTrigger trigger, NotificationRule rule) {
        return String.join((CharSequence)"_", trigger.getDeduplicationKey(), rule.getDeduplicationKey());
    }

    private long getDeduplicationDuration(NotificationRuleTrigger trigger) {
        return this.deduplicationDurations.computeIfAbsent(trigger.getType(), triggerType -> trigger.getDefaultDeduplicationDuration());
    }

    private Cache getExternalCache() {
        return Optional.ofNullable(this.cacheManager).map(cacheManager -> cacheManager.getCache("sentNotifications")).orElse(null);
    }

    @Autowired
    public void setDeduplicationDurations(@Value(value="${notification_system.rules.deduplication_durations:}") String deduplicationDurationsStr) {
        this.deduplicationDurations = new ConcurrentHashMap<NotificationRuleTriggerType, Long>();
        PropertyUtils.getProps(deduplicationDurationsStr).forEach((triggerType, duration) -> this.deduplicationDurations.put(NotificationRuleTriggerType.valueOf((String)triggerType), Long.parseLong(duration)));
    }

    @Generated
    public DefaultNotificationDeduplicationService() {
    }
}

