/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.memory;

import lombok.Generated;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.memory.InMemoryStorage;

public class InMemoryTbQueueProducer<T extends TbQueueMsg>
implements TbQueueProducer<T> {
    private final InMemoryStorage storage;
    private final String defaultTopic;

    public InMemoryTbQueueProducer(InMemoryStorage storage, String defaultTopic) {
        this.storage = storage;
        this.defaultTopic = defaultTopic;
    }

    public void send(TopicPartitionInfo tpi, T msg, TbQueueCallback callback) {
        boolean result = this.storage.put(tpi.getFullTopicName(), (TbQueueMsg)msg);
        if (result) {
            if (callback != null) {
                callback.onSuccess(null);
            }
        } else if (callback != null) {
            callback.onFailure((Throwable)new RuntimeException("Failure add msg to InMemoryQueue"));
        }
    }

    public void stop() {
    }

    @Generated
    public InMemoryStorage getStorage() {
        return this.storage;
    }

    @Generated
    public String getDefaultTopic() {
        return this.defaultTopic;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InMemoryTbQueueProducer)) {
            return false;
        }
        InMemoryTbQueueProducer other = (InMemoryTbQueueProducer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InMemoryStorage this$storage = this.getStorage();
        InMemoryStorage other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$defaultTopic = this.getDefaultTopic();
        String other$defaultTopic = other.getDefaultTopic();
        return !(this$defaultTopic == null ? other$defaultTopic != null : !this$defaultTopic.equals(other$defaultTopic));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InMemoryTbQueueProducer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InMemoryStorage $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $defaultTopic = this.getDefaultTopic();
        result = result * 59 + ($defaultTopic == null ? 43 : $defaultTopic.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InMemoryTbQueueProducer(storage=" + String.valueOf(this.getStorage()) + ", defaultTopic=" + this.getDefaultTopic() + ")";
    }
}

