/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.kafka;

import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.TbProperty;
import org.thingsboard.server.queue.kafka.KafkaAdmin;
import org.thingsboard.server.queue.util.PropertyUtils;
import org.thingsboard.server.queue.util.TbKafkaComponent;

@TbKafkaComponent
@ConfigurationProperties(prefix="queue.kafka")
@Component
public class TbKafkaSettings {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbKafkaSettings.class);
    @Value(value="${queue.kafka.bootstrap.servers}")
    private String servers;
    @Value(value="${queue.kafka.ssl.enabled:false}")
    private boolean sslEnabled;
    @Value(value="${queue.kafka.ssl.truststore.location:}")
    private String sslTruststoreLocation;
    @Value(value="${queue.kafka.ssl.truststore.password:}")
    private String sslTruststorePassword;
    @Value(value="${queue.kafka.ssl.keystore.location:}")
    private String sslKeystoreLocation;
    @Value(value="${queue.kafka.ssl.keystore.password:}")
    private String sslKeystorePassword;
    @Value(value="${queue.kafka.ssl.key.password:}")
    private String sslKeyPassword;
    @Value(value="${queue.kafka.acks:all}")
    private String acks;
    @Value(value="${queue.kafka.retries:1}")
    private int retries;
    @Value(value="${queue.kafka.compression.type:none}")
    private String compressionType;
    @Value(value="${queue.kafka.batch.size:16384}")
    private int batchSize;
    @Value(value="${queue.kafka.linger.ms:1}")
    private long lingerMs;
    @Value(value="${queue.kafka.max.request.size:1048576}")
    private int maxRequestSize;
    @Value(value="${queue.kafka.max.in.flight.requests.per.connection:5}")
    private int maxInFlightRequestsPerConnection;
    @Value(value="${queue.kafka.buffer.memory:33554432}")
    private long bufferMemory;
    @Value(value="${queue.kafka.replication_factor:1}")
    private short replicationFactor;
    @Value(value="${queue.kafka.max_poll_records:8192}")
    private int maxPollRecords;
    @Value(value="${queue.kafka.max_poll_interval_ms:300000}")
    private int maxPollIntervalMs;
    @Value(value="${queue.kafka.max_partition_fetch_bytes:16777216}")
    private int maxPartitionFetchBytes;
    @Value(value="${queue.kafka.fetch_max_bytes:134217728}")
    private int fetchMaxBytes;
    @Value(value="${queue.kafka.request.timeout.ms:30000}")
    private int requestTimeoutMs;
    @Value(value="${queue.kafka.session.timeout.ms:10000}")
    private int sessionTimeoutMs;
    @Value(value="${queue.kafka.auto_offset_reset:earliest}")
    private String autoOffsetReset;
    @Value(value="${queue.kafka.use_confluent_cloud:false}")
    private boolean useConfluent;
    @Value(value="${queue.kafka.confluent.ssl.algorithm:}")
    private String sslAlgorithm;
    @Value(value="${queue.kafka.confluent.sasl.mechanism:}")
    private String saslMechanism;
    @Value(value="${queue.kafka.confluent.sasl.config:}")
    private String saslConfig;
    @Value(value="${queue.kafka.confluent.security.protocol:}")
    private String securityProtocol;
    @Value(value="${queue.kafka.other-inline:}")
    private String otherInline;
    @Value(value="${queue.kafka.consumer-properties-per-topic-inline:}")
    private String consumerPropertiesPerTopicInline;
    @Autowired
    private KafkaAdmin kafkaAdmin;
    @Deprecated
    private List<TbProperty> other;
    private Map<String, List<TbProperty>> consumerPropertiesPerTopic = new HashMap<String, List<TbProperty>>();

    @PostConstruct
    public void initInlineTopicProperties() {
        Map<String, List<TbProperty>> inlineProps = this.parseTopicPropertyList(this.consumerPropertiesPerTopicInline);
        if (!inlineProps.isEmpty()) {
            this.consumerPropertiesPerTopic.putAll(inlineProps);
        }
    }

    public Properties toConsumerProps(String topic) {
        Properties props = this.toProps();
        props.put("bootstrap.servers", this.servers);
        props.put("max.poll.records", (Object)this.maxPollRecords);
        props.put("session.timeout.ms", (Object)this.sessionTimeoutMs);
        props.put("max.partition.fetch.bytes", (Object)this.maxPartitionFetchBytes);
        props.put("fetch.max.bytes", (Object)this.fetchMaxBytes);
        props.put("max.poll.interval.ms", (Object)this.maxPollIntervalMs);
        props.put("auto.offset.reset", this.autoOffsetReset);
        props.put("enable.auto.commit", (Object)false);
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", ByteArrayDeserializer.class);
        if (topic != null) {
            List<TbProperty> properties = this.consumerPropertiesPerTopic.get(topic);
            if (properties == null) {
                for (Map.Entry<String, List<TbProperty>> entry : this.consumerPropertiesPerTopic.entrySet()) {
                    if (!topic.startsWith(entry.getKey())) continue;
                    properties = entry.getValue();
                    break;
                }
            }
            if (properties != null) {
                properties.forEach(kv -> props.put(kv.getKey(), kv.getValue()));
            }
        }
        return props;
    }

    public Properties toProducerProps() {
        Properties props = this.toProps();
        props.put("bootstrap.servers", this.servers);
        props.put("retries", (Object)this.retries);
        props.put("acks", this.acks);
        props.put("batch.size", (Object)this.batchSize);
        props.put("linger.ms", (Object)this.lingerMs);
        props.put("buffer.memory", (Object)this.bufferMemory);
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", ByteArraySerializer.class);
        props.put("compression.type", this.compressionType);
        props.put("max.request.size", (Object)this.maxRequestSize);
        props.put("max.in.flight.requests.per.connection", (Object)this.maxInFlightRequestsPerConnection);
        return props;
    }

    Properties toProps() {
        Properties props = new Properties();
        if (this.useConfluent) {
            props.put("ssl.endpoint.identification.algorithm", this.sslAlgorithm);
            props.put("sasl.mechanism", this.saslMechanism);
            props.put("sasl.jaas.config", this.saslConfig);
            props.put("security.protocol", this.securityProtocol);
        }
        props.put("request.timeout.ms", (Object)this.requestTimeoutMs);
        props.putAll(PropertyUtils.getProps(this.otherInline));
        if (this.other != null) {
            this.other.forEach(kv -> props.put(kv.getKey(), kv.getValue()));
        }
        this.configureSSL(props);
        return props;
    }

    void configureSSL(Properties props) {
        if (this.sslEnabled) {
            props.put("security.protocol", "SSL");
            props.put("ssl.truststore.location", this.sslTruststoreLocation);
            props.put("ssl.truststore.password", this.sslTruststorePassword);
            props.put("ssl.keystore.location", this.sslKeystoreLocation);
            props.put("ssl.keystore.password", this.sslKeystorePassword);
            props.put("ssl.key.password", this.sslKeyPassword);
        }
    }

    public KafkaAdmin getAdmin() {
        return this.kafkaAdmin;
    }

    protected Properties toAdminProps() {
        Properties props = this.toProps();
        props.put("bootstrap.servers", this.servers);
        props.put("retries", (Object)this.retries);
        return props;
    }

    private Map<String, List<TbProperty>> parseTopicPropertyList(String inlineProperties) {
        Map<String, List<String>> grouped = PropertyUtils.getGroupedProps(inlineProperties);
        HashMap<String, List<TbProperty>> result = new HashMap<String, List<TbProperty>>();
        grouped.forEach((topic, entries) -> {
            LinkedHashMap<String, String> merged = new LinkedHashMap<String, String>();
            for (String entry : entries) {
                String[] kv = entry.split("=", 2);
                if (kv.length != 2) continue;
                merged.put(kv[0].trim(), kv[1].trim());
            }
            List<TbProperty> props = merged.entrySet().stream().map(e -> new TbProperty((String)e.getKey(), (String)e.getValue())).toList();
            result.put((String)topic, props);
        });
        return result;
    }

    @Generated
    public short getReplicationFactor() {
        return this.replicationFactor;
    }

    @Deprecated
    @Generated
    public void setOther(List<TbProperty> other) {
        this.other = other;
    }

    @Generated
    public void setConsumerPropertiesPerTopic(Map<String, List<TbProperty>> consumerPropertiesPerTopic) {
        this.consumerPropertiesPerTopic = consumerPropertiesPerTopic;
    }
}

