/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.kafka;

import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.queue.TbEdgeQueueAdmin;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.kafka.TbKafkaSettings;
import org.thingsboard.server.queue.util.PropertyUtils;

public class TbKafkaAdmin
implements TbQueueAdmin,
TbEdgeQueueAdmin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbKafkaAdmin.class);
    private final TbKafkaSettings settings;
    private final Map<String, String> topicConfigs;
    private final int numPartitions;

    public TbKafkaAdmin(TbKafkaSettings settings, Map<String, String> topicConfigs) {
        this.settings = settings;
        this.topicConfigs = topicConfigs;
        String numPartitionsStr = topicConfigs.get("partitions");
        this.numPartitions = numPartitionsStr != null ? Integer.parseInt(numPartitionsStr) : 1;
    }

    public void createTopicIfNotExists(String topic, String properties, boolean force) {
        this.settings.getAdmin().createTopicIfNotExists(topic, PropertyUtils.getProps(this.topicConfigs, properties), force);
    }

    public void deleteTopic(String topic) {
        this.settings.getAdmin().deleteTopic(topic);
    }

    public void destroy() {
    }

    public void syncEdgeNotificationsOffsets(String fatGroupId, String newGroupId) {
        try {
            log.info("syncEdgeNotificationsOffsets [{}][{}]", (Object)fatGroupId, (Object)newGroupId);
            this.settings.getAdmin().syncOffsetsUnsafe(fatGroupId, newGroupId, newGroupId);
        }
        catch (Exception e) {
            log.warn("Failed to syncEdgeNotificationsOffsets from {} to {}", new Object[]{fatGroupId, newGroupId, e});
        }
    }

    @Generated
    public int getNumPartitions() {
        return this.numPartitions;
    }
}

