/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.kafka;

import java.util.UUID;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueMsgHeaders;
import org.thingsboard.server.queue.common.DefaultTbQueueMsgHeaders;

public class KafkaTbQueueMsg
implements TbQueueMsg {
    private static final int UUID_LENGTH = 36;
    private final UUID key;
    private final TbQueueMsgHeaders headers;
    private final byte[] data;

    public KafkaTbQueueMsg(ConsumerRecord<String, byte[]> record) {
        this.key = ((String)record.key()).length() <= 36 ? UUID.fromString((String)record.key()) : UUID.randomUUID();
        DefaultTbQueueMsgHeaders headers = new DefaultTbQueueMsgHeaders();
        record.headers().forEach(header -> headers.put(header.key(), header.value()));
        this.headers = headers;
        this.data = (byte[])record.value();
    }

    public UUID getKey() {
        return this.key;
    }

    public TbQueueMsgHeaders getHeaders() {
        return this.headers;
    }

    public byte[] getData() {
        return this.data;
    }
}

