/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.housekeeper;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.common.msg.housekeeper.HousekeeperClient;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsgMetadata;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.housekeeper.HousekeeperConfig;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;

@Service
public class DefaultHousekeeperClient
implements HousekeeperClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultHousekeeperClient.class);
    private final HousekeeperConfig config;
    private final TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>> producer;
    private final TopicPartitionInfo submitTpi;
    private final TbQueueCallback submitCallback;

    public DefaultHousekeeperClient(HousekeeperConfig config, TbQueueProducerProvider producerProvider) {
        this.config = config;
        this.producer = producerProvider.getHousekeeperMsgProducer();
        this.submitTpi = TopicPartitionInfo.builder().topic(this.producer.getDefaultTopic()).build();
        this.submitCallback = new TbQueueCallback(){

            public void onSuccess(TbQueueMsgMetadata metadata) {
                log.trace("Submitted Housekeeper task");
            }

            public void onFailure(Throwable t) {
                log.error("Failed to submit Housekeeper task", t);
            }
        };
    }

    public void submitTask(HousekeeperTask task) {
        HousekeeperTaskType taskType = task.getTaskType();
        if (this.config.getDisabledTaskTypes().contains(taskType)) {
            log.trace("Task type {} is disabled, ignoring {}", (Object)taskType, (Object)task);
            return;
        }
        log.debug("[{}][{}][{}] Submitting task: {}", new Object[]{task.getTenantId(), task.getEntityId().getEntityType(), task.getEntityId(), task});
        try {
            this.producer.send(this.submitTpi, new TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>(task.getEntityId().getId(), TransportProtos.ToHousekeeperServiceMsg.newBuilder().setTask(TransportProtos.HousekeeperTaskProto.newBuilder().setValue(JacksonUtil.toString((Object)task)).setTs(task.getTs()).setAttempt(0).build()).build()), this.submitCallback);
        }
        catch (Throwable t) {
            log.error("Failed to submit Housekeeper task {}", (Object)task, (Object)t);
        }
    }
}

