/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.environment;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.thingsboard.server.queue.discovery.ZkDiscoveryService;
import org.thingsboard.server.queue.environment.DistributedLock;
import org.thingsboard.server.queue.environment.DistributedLockService;

@Service
@ConditionalOnProperty(prefix="zk", value={"enabled"}, havingValue="true")
public class ZkDistributedLockService
implements DistributedLockService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZkDistributedLockService.class);
    private final ZkDiscoveryService zkDiscoveryService;

    @Override
    public DistributedLock getLock(String key) {
        return new ZkDistributedLock(key);
    }

    @ConstructorProperties(value={"zkDiscoveryService"})
    @Generated
    public ZkDistributedLockService(ZkDiscoveryService zkDiscoveryService) {
        this.zkDiscoveryService = zkDiscoveryService;
    }

    private class ZkDistributedLock
    implements DistributedLock {
        private final InterProcessLock interProcessLock;

        public ZkDistributedLock(String key) {
            this.interProcessLock = new InterProcessMutex(ZkDistributedLockService.this.zkDiscoveryService.getClient(), ZkDistributedLockService.this.zkDiscoveryService.getZkDir() + "/locks/" + key);
        }

        @Override
        public void lock() {
            this.interProcessLock.acquire();
        }

        @Override
        public void unlock() {
            this.interProcessLock.release();
        }

        @ConstructorProperties(value={"interProcessLock"})
        @Generated
        public ZkDistributedLock(InterProcessLock interProcessLock) {
            this.interProcessLock = interProcessLock;
        }
    }
}

