/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.edqs;

import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.stats.StatsFactory;
import org.thingsboard.server.common.stats.StatsType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueHandler;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.PartitionedQueueResponseTemplate;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.edqs.EdqsConfig;
import org.thingsboard.server.queue.edqs.EdqsExecutors;
import org.thingsboard.server.queue.edqs.EdqsQueueFactory;
import org.thingsboard.server.queue.edqs.InMemoryEdqsComponent;
import org.thingsboard.server.queue.memory.InMemoryStorage;
import org.thingsboard.server.queue.memory.InMemoryTbQueueConsumer;
import org.thingsboard.server.queue.memory.InMemoryTbQueueProducer;

@Component
@InMemoryEdqsComponent
public class InMemoryEdqsQueueFactory
implements EdqsQueueFactory {
    private final InMemoryStorage storage;
    private final EdqsConfig edqsConfig;
    private final EdqsExecutors edqsExecutors;
    private final StatsFactory statsFactory;
    private final TbQueueAdmin queueAdmin;

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToEdqsMsg>> createEdqsEventsConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToEdqsMsg>>(this.storage, this.edqsConfig.getEventsTopic());
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToEdqsMsg>> createEdqsEventsToBackupConsumer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToEdqsMsg>> createEdqsStateConsumer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToEdqsMsg>> createEdqsStateProducer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PartitionedQueueResponseTemplate<TbProtoQueueMsg<TransportProtos.ToEdqsMsg>, TbProtoQueueMsg<TransportProtos.FromEdqsMsg>> createEdqsResponseTemplate(TbQueueHandler<TbProtoQueueMsg<TransportProtos.ToEdqsMsg>, TbProtoQueueMsg<TransportProtos.FromEdqsMsg>> handler) {
        InMemoryTbQueueProducer responseProducer = new InMemoryTbQueueProducer(this.storage, this.edqsConfig.getResponsesTopic());
        return PartitionedQueueResponseTemplate.builder().key("edqs").handler(handler).requestsTopic(this.edqsConfig.getRequestsTopic()).consumerCreator(tpi -> new InMemoryTbQueueConsumer(this.storage, this.edqsConfig.getRequestsTopic())).responseProducer(responseProducer).pollInterval(this.edqsConfig.getPollInterval()).requestTimeout(this.edqsConfig.getMaxRequestTimeout()).maxPendingRequests(this.edqsConfig.getMaxPendingRequests()).consumerExecutor(this.edqsExecutors.getConsumersExecutor()).callbackExecutor((ExecutorService)this.edqsExecutors.getRequestExecutor()).consumerTaskExecutor(this.edqsExecutors.getConsumerTaskExecutor()).stats(this.statsFactory.createMessagesStats(StatsType.EDQS.getName())).build();
    }

    @Override
    public TbQueueAdmin getEdqsQueueAdmin() {
        return this.queueAdmin;
    }

    @ConstructorProperties(value={"storage", "edqsConfig", "edqsExecutors", "statsFactory", "queueAdmin"})
    @Generated
    public InMemoryEdqsQueueFactory(InMemoryStorage storage, EdqsConfig edqsConfig, EdqsExecutors edqsExecutors, StatsFactory statsFactory, TbQueueAdmin queueAdmin) {
        this.storage = storage;
        this.edqsConfig = edqsConfig;
        this.edqsExecutors = edqsExecutors;
        this.statsFactory = statsFactory;
        this.queueAdmin = queueAdmin;
    }
}

