/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.edqs;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.queue.edqs.EdqsConfig;

@Lazy
@Component
public class EdqsExecutors {
    private final EdqsConfig edqsConfig;
    private ExecutorService consumersExecutor;
    private ExecutorService consumerTaskExecutor;
    private ScheduledExecutorService scheduler;
    private ListeningExecutorService requestExecutor;

    @PostConstruct
    private void init() {
        this.consumersExecutor = Executors.newCachedThreadPool((ThreadFactory)ThingsBoardThreadFactory.forName((String)"edqs-consumer"));
        this.consumerTaskExecutor = ThingsBoardExecutors.newWorkStealingPool((int)4, (String)"edqs-consumer-task-executor");
        this.scheduler = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"edqs-scheduler");
        this.requestExecutor = MoreExecutors.listeningDecorator((ExecutorService)ThingsBoardExecutors.newWorkStealingPool((int)this.edqsConfig.getRequestExecutorSize(), (String)"edqs-requests"));
    }

    @PreDestroy
    private void destroy() {
        if (this.consumersExecutor != null) {
            this.consumersExecutor.shutdownNow();
        }
        if (this.consumerTaskExecutor != null) {
            this.consumerTaskExecutor.shutdownNow();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        if (this.requestExecutor != null) {
            this.requestExecutor.shutdownNow();
        }
    }

    @Generated
    public EdqsConfig getEdqsConfig() {
        return this.edqsConfig;
    }

    @Generated
    public ExecutorService getConsumersExecutor() {
        return this.consumersExecutor;
    }

    @Generated
    public ExecutorService getConsumerTaskExecutor() {
        return this.consumerTaskExecutor;
    }

    @Generated
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Generated
    public ListeningExecutorService getRequestExecutor() {
        return this.requestExecutor;
    }

    @ConstructorProperties(value={"edqsConfig"})
    @Generated
    public EdqsExecutors(EdqsConfig edqsConfig) {
        this.edqsConfig = edqsConfig;
    }
}

