/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.edqs;

import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EdqsConfig {
    @Value(value="${queue.edqs.partitions:12}")
    private int partitions;
    @Value(value="${service.edqs.label:}")
    private String label;
    @Value(value="#{'${queue.edqs.partitioning_strategy:tenant}'.toUpperCase()}")
    private EdqsPartitioningStrategy partitioningStrategy;
    @Value(value="${queue.edqs.events_topic:edqs.events}")
    private String eventsTopic;
    @Value(value="${queue.edqs.state_topic:edqs.state}")
    private String stateTopic;
    @Value(value="${queue.edqs.requests_topic:edqs.requests}")
    private String requestsTopic;
    @Value(value="${queue.edqs.responses_topic:edqs.responses}")
    private String responsesTopic;
    @Value(value="${queue.edqs.poll_interval:25}")
    private long pollInterval;
    @Value(value="${queue.edqs.max_pending_requests:10000}")
    private int maxPendingRequests;
    @Value(value="${queue.edqs.max_request_timeout:20000}")
    private int maxRequestTimeout;
    @Value(value="${queue.edqs.request_executor_size:50}")
    private int requestExecutorSize;
    @Value(value="${queue.edqs.versions_cache_ttl:60}")
    private int versionsCacheTtl;

    public String getLabel() {
        if (this.partitioningStrategy == EdqsPartitioningStrategy.NONE) {
            this.label = "all";
        }
        return this.label;
    }

    @Generated
    public EdqsConfig() {
    }

    @Generated
    public int getPartitions() {
        return this.partitions;
    }

    @Generated
    public EdqsPartitioningStrategy getPartitioningStrategy() {
        return this.partitioningStrategy;
    }

    @Generated
    public String getEventsTopic() {
        return this.eventsTopic;
    }

    @Generated
    public String getStateTopic() {
        return this.stateTopic;
    }

    @Generated
    public String getRequestsTopic() {
        return this.requestsTopic;
    }

    @Generated
    public String getResponsesTopic() {
        return this.responsesTopic;
    }

    @Generated
    public long getPollInterval() {
        return this.pollInterval;
    }

    @Generated
    public int getMaxPendingRequests() {
        return this.maxPendingRequests;
    }

    @Generated
    public int getMaxRequestTimeout() {
        return this.maxRequestTimeout;
    }

    @Generated
    public int getRequestExecutorSize() {
        return this.requestExecutorSize;
    }

    @Generated
    public int getVersionsCacheTtl() {
        return this.versionsCacheTtl;
    }

    @Generated
    public void setPartitions(int partitions) {
        this.partitions = partitions;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setPartitioningStrategy(EdqsPartitioningStrategy partitioningStrategy) {
        this.partitioningStrategy = partitioningStrategy;
    }

    @Generated
    public void setEventsTopic(String eventsTopic) {
        this.eventsTopic = eventsTopic;
    }

    @Generated
    public void setStateTopic(String stateTopic) {
        this.stateTopic = stateTopic;
    }

    @Generated
    public void setRequestsTopic(String requestsTopic) {
        this.requestsTopic = requestsTopic;
    }

    @Generated
    public void setResponsesTopic(String responsesTopic) {
        this.responsesTopic = responsesTopic;
    }

    @Generated
    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    @Generated
    public void setMaxPendingRequests(int maxPendingRequests) {
        this.maxPendingRequests = maxPendingRequests;
    }

    @Generated
    public void setMaxRequestTimeout(int maxRequestTimeout) {
        this.maxRequestTimeout = maxRequestTimeout;
    }

    @Generated
    public void setRequestExecutorSize(int requestExecutorSize) {
        this.requestExecutorSize = requestExecutorSize;
    }

    @Generated
    public void setVersionsCacheTtl(int versionsCacheTtl) {
        this.versionsCacheTtl = versionsCacheTtl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdqsConfig)) {
            return false;
        }
        EdqsConfig other = (EdqsConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPartitions() != other.getPartitions()) {
            return false;
        }
        if (this.getPollInterval() != other.getPollInterval()) {
            return false;
        }
        if (this.getMaxPendingRequests() != other.getMaxPendingRequests()) {
            return false;
        }
        if (this.getMaxRequestTimeout() != other.getMaxRequestTimeout()) {
            return false;
        }
        if (this.getRequestExecutorSize() != other.getRequestExecutorSize()) {
            return false;
        }
        if (this.getVersionsCacheTtl() != other.getVersionsCacheTtl()) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        EdqsPartitioningStrategy this$partitioningStrategy = this.getPartitioningStrategy();
        EdqsPartitioningStrategy other$partitioningStrategy = other.getPartitioningStrategy();
        if (this$partitioningStrategy == null ? other$partitioningStrategy != null : !((Object)((Object)this$partitioningStrategy)).equals((Object)other$partitioningStrategy)) {
            return false;
        }
        String this$eventsTopic = this.getEventsTopic();
        String other$eventsTopic = other.getEventsTopic();
        if (this$eventsTopic == null ? other$eventsTopic != null : !this$eventsTopic.equals(other$eventsTopic)) {
            return false;
        }
        String this$stateTopic = this.getStateTopic();
        String other$stateTopic = other.getStateTopic();
        if (this$stateTopic == null ? other$stateTopic != null : !this$stateTopic.equals(other$stateTopic)) {
            return false;
        }
        String this$requestsTopic = this.getRequestsTopic();
        String other$requestsTopic = other.getRequestsTopic();
        if (this$requestsTopic == null ? other$requestsTopic != null : !this$requestsTopic.equals(other$requestsTopic)) {
            return false;
        }
        String this$responsesTopic = this.getResponsesTopic();
        String other$responsesTopic = other.getResponsesTopic();
        return !(this$responsesTopic == null ? other$responsesTopic != null : !this$responsesTopic.equals(other$responsesTopic));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EdqsConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartitions();
        long $pollInterval = this.getPollInterval();
        result = result * 59 + (int)($pollInterval >>> 32 ^ $pollInterval);
        result = result * 59 + this.getMaxPendingRequests();
        result = result * 59 + this.getMaxRequestTimeout();
        result = result * 59 + this.getRequestExecutorSize();
        result = result * 59 + this.getVersionsCacheTtl();
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        EdqsPartitioningStrategy $partitioningStrategy = this.getPartitioningStrategy();
        result = result * 59 + ($partitioningStrategy == null ? 43 : ((Object)((Object)$partitioningStrategy)).hashCode());
        String $eventsTopic = this.getEventsTopic();
        result = result * 59 + ($eventsTopic == null ? 43 : $eventsTopic.hashCode());
        String $stateTopic = this.getStateTopic();
        result = result * 59 + ($stateTopic == null ? 43 : $stateTopic.hashCode());
        String $requestsTopic = this.getRequestsTopic();
        result = result * 59 + ($requestsTopic == null ? 43 : $requestsTopic.hashCode());
        String $responsesTopic = this.getResponsesTopic();
        result = result * 59 + ($responsesTopic == null ? 43 : $responsesTopic.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EdqsConfig(partitions=" + this.getPartitions() + ", label=" + this.getLabel() + ", partitioningStrategy=" + String.valueOf((Object)this.getPartitioningStrategy()) + ", eventsTopic=" + this.getEventsTopic() + ", stateTopic=" + this.getStateTopic() + ", requestsTopic=" + this.getRequestsTopic() + ", responsesTopic=" + this.getResponsesTopic() + ", pollInterval=" + this.getPollInterval() + ", maxPendingRequests=" + this.getMaxPendingRequests() + ", maxRequestTimeout=" + this.getMaxRequestTimeout() + ", requestExecutorSize=" + this.getRequestExecutorSize() + ", versionsCacheTtl=" + this.getVersionsCacheTtl() + ")";
    }

    public static enum EdqsPartitioningStrategy {
        TENANT,
        NONE;

    }
}

