/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.discovery.event;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.queue.discovery.QueueKey;
import org.thingsboard.server.queue.discovery.event.TbApplicationEvent;

public class PartitionChangeEvent
extends TbApplicationEvent {
    private static final long serialVersionUID = -8731788167026510559L;
    private final ServiceType serviceType;
    private final Map<QueueKey, Set<TopicPartitionInfo>> newPartitions;
    private final Map<QueueKey, Set<TopicPartitionInfo>> oldPartitions;

    public PartitionChangeEvent(Object source, ServiceType serviceType, Map<QueueKey, Set<TopicPartitionInfo>> newPartitions, Map<QueueKey, Set<TopicPartitionInfo>> oldPartitions) {
        super(source);
        this.serviceType = serviceType;
        this.newPartitions = newPartitions;
        this.oldPartitions = oldPartitions;
    }

    public Set<TopicPartitionInfo> getCorePartitions() {
        return this.getPartitionsByServiceTypeAndQueueName(ServiceType.TB_CORE, "Main");
    }

    public Set<TopicPartitionInfo> getEdgePartitions() {
        return this.getPartitionsByServiceTypeAndQueueName(ServiceType.TB_CORE, "Edge");
    }

    public Set<TopicPartitionInfo> getPartitions() {
        return this.newPartitions.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<TopicPartitionInfo> getCfPartitions() {
        return this.getPartitionsByServiceTypeAndQueueName(ServiceType.TB_RULE_ENGINE, "CalculatedFields");
    }

    public Set<TopicPartitionInfo> getPartitionsByServiceTypeAndQueueName(ServiceType serviceType, String queueName) {
        return this.newPartitions.entrySet().stream().filter(entry -> serviceType.equals((Object)((QueueKey)entry.getKey()).getType()) && queueName.equals(((QueueKey)entry.getKey()).getQueueName())).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    @Override
    @Generated
    public String toString() {
        return "PartitionChangeEvent(super=" + super.toString() + ", serviceType=" + String.valueOf(this.getServiceType()) + ", newPartitions=" + String.valueOf(this.getNewPartitions()) + ", oldPartitions=" + String.valueOf(this.getOldPartitions()) + ")";
    }

    @Generated
    public ServiceType getServiceType() {
        return this.serviceType;
    }

    @Generated
    public Map<QueueKey, Set<TopicPartitionInfo>> getNewPartitions() {
        return this.newPartitions;
    }

    @Generated
    public Map<QueueKey, Set<TopicPartitionInfo>> getOldPartitions() {
        return this.oldPartitions;
    }
}

