/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.discovery;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;

@Service
public class TopicService {
    @Value(value="${queue.prefix:}")
    private String prefix;
    @Value(value="${queue.core.notifications-topic:tb_core.notifications}")
    private String tbCoreNotificationsTopic;
    @Value(value="${queue.rule-engine.notifications-topic:tb_rule_engine.notifications}")
    private String tbRuleEngineNotificationsTopic;
    @Value(value="${queue.transport.notifications-topic:tb_transport.notifications}")
    private String tbTransportNotificationsTopic;
    @Value(value="${queue.edge.notifications-topic:tb_edge.notifications}")
    private String tbEdgeNotificationsTopic;
    @Value(value="${queue.edge.event-notifications-topic:tb_edge_event.notifications}")
    private String tbEdgeEventNotificationsTopic;
    @Value(value="${queue.calculated-fields.notifications-topic:calculated_field.notifications}")
    private String tbCalculatedFieldNotificationsTopic;
    private final ConcurrentMap<String, TopicPartitionInfo> tbCoreNotificationTopics = new ConcurrentHashMap<String, TopicPartitionInfo>();
    private final ConcurrentMap<String, TopicPartitionInfo> tbRuleEngineNotificationTopics = new ConcurrentHashMap<String, TopicPartitionInfo>();
    private final ConcurrentMap<String, TopicPartitionInfo> tbEdgeNotificationTopics = new ConcurrentHashMap<String, TopicPartitionInfo>();
    private final ConcurrentMap<String, TopicPartitionInfo> tbCalculatedFieldNotificationTopics = new ConcurrentHashMap<String, TopicPartitionInfo>();
    private final ConcurrentReferenceHashMap<EdgeId, TopicPartitionInfo> tbEdgeEventsNotificationTopics = new ConcurrentReferenceHashMap();

    public TopicPartitionInfo getNotificationsTopic(ServiceType serviceType, String serviceId) {
        return switch (serviceType) {
            case ServiceType.TB_CORE -> this.tbCoreNotificationTopics.computeIfAbsent(serviceId, id -> this.buildNotificationsTopicPartitionInfo(this.tbCoreNotificationsTopic, serviceId));
            case ServiceType.TB_RULE_ENGINE -> this.tbRuleEngineNotificationTopics.computeIfAbsent(serviceId, id -> this.buildNotificationsTopicPartitionInfo(this.tbRuleEngineNotificationsTopic, serviceId));
            case ServiceType.TB_TRANSPORT -> this.buildNotificationsTopicPartitionInfo(this.tbTransportNotificationsTopic, serviceId);
            default -> throw new IllegalStateException("Unexpected service type: " + String.valueOf(serviceType));
        };
    }

    private TopicPartitionInfo buildNotificationsTopicPartitionInfo(String topic, String serviceId) {
        return this.buildTopicPartitionInfo(this.buildNotificationTopicName(topic, serviceId), null, null, false);
    }

    public TopicPartitionInfo buildTopicPartitionInfo(String topic, TenantId tenantId, Integer partition, boolean myPartition) {
        return new TopicPartitionInfo(this.buildTopicName(topic), tenantId, partition, myPartition);
    }

    public TopicPartitionInfo getEdgeNotificationsTopic(String serviceId) {
        return this.tbEdgeNotificationTopics.computeIfAbsent(serviceId, id -> this.buildEdgeNotificationsTopicPartitionInfo(serviceId));
    }

    private TopicPartitionInfo buildEdgeNotificationsTopicPartitionInfo(String serviceId) {
        return this.buildTopicPartitionInfo(this.buildNotificationTopicName(this.tbEdgeNotificationsTopic, serviceId), null, null, false);
    }

    public TopicPartitionInfo getCalculatedFieldNotificationsTopic(String serviceId) {
        return this.tbCalculatedFieldNotificationTopics.computeIfAbsent(serviceId, id -> this.buildNotificationsTopicPartitionInfo(this.tbCalculatedFieldNotificationsTopic, serviceId));
    }

    public TopicPartitionInfo getEdgeEventNotificationsTopic(TenantId tenantId, EdgeId edgeId) {
        return (TopicPartitionInfo)this.tbEdgeEventsNotificationTopics.computeIfAbsent((Object)edgeId, id -> this.buildEdgeEventNotificationsTopicPartitionInfo(tenantId, edgeId));
    }

    public TopicPartitionInfo buildEdgeEventNotificationsTopicPartitionInfo(TenantId tenantId, EdgeId edgeId) {
        return this.buildTopicPartitionInfo(this.tbEdgeEventNotificationsTopic + "." + String.valueOf(tenantId) + "." + String.valueOf(edgeId), null, null, false);
    }

    public String buildTopicName(String topic) {
        if (topic == null) {
            return null;
        }
        return this.prefix.isBlank() ? topic : this.prefix + "." + topic;
    }

    private String buildNotificationTopicName(String topic, String serviceId) {
        return topic + "." + serviceId;
    }

    public String buildConsumerGroupId(String servicePrefix, TenantId tenantId, String queueName, Integer partitionId) {
        return this.buildTopicName(servicePrefix + queueName + (String)(tenantId.isSysTenantId() ? "" : "-isolated-" + String.valueOf(tenantId)) + "-consumer" + this.suffix(partitionId));
    }

    String suffix(Integer partitionId) {
        return partitionId == null ? "" : "-" + partitionId;
    }
}

