/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.discovery;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.thingsboard.server.queue.discovery.event.TbApplicationEvent;

public abstract class TbApplicationEventListener<T extends TbApplicationEvent>
implements ApplicationListener<T> {
    private int lastProcessedSequenceNumber = Integer.MIN_VALUE;
    private final Lock seqNumberLock = new ReentrantLock();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void onApplicationEvent(T event) {
        if (!this.filterTbApplicationEvent(event)) {
            this.log.trace("Skipping event due to filter: {}", event);
            return;
        }
        boolean validUpdate = false;
        this.seqNumberLock.lock();
        try {
            if (((TbApplicationEvent)((Object)event)).getSequenceNumber() > this.lastProcessedSequenceNumber) {
                validUpdate = true;
                this.lastProcessedSequenceNumber = ((TbApplicationEvent)((Object)event)).getSequenceNumber();
            }
        }
        finally {
            this.seqNumberLock.unlock();
        }
        if (validUpdate) {
            try {
                this.onTbApplicationEvent(event);
            }
            catch (Exception e) {
                this.log.error("Failed to handle partition change event: {}", event, (Object)e);
            }
        } else {
            this.log.info("Application event ignored due to invalid sequence number ({} > {}). Event: {}", new Object[]{this.lastProcessedSequenceNumber, ((TbApplicationEvent)((Object)event)).getSequenceNumber(), event});
        }
    }

    protected abstract void onTbApplicationEvent(T var1);

    protected boolean filterTbApplicationEvent(T event) {
        return true;
    }
}

