/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.discovery;

import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.id.QueueId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.gen.transport.TransportProtos;

public class QueueRoutingInfo {
    private final TenantId tenantId;
    private final QueueId queueId;
    private final String queueName;
    private final String queueTopic;
    private final int partitions;
    private final boolean duplicateMsgToAllPartitions;

    public QueueRoutingInfo(Queue queue) {
        this.tenantId = queue.getTenantId();
        this.queueId = (QueueId)queue.getId();
        this.queueName = queue.getName();
        this.queueTopic = queue.getTopic();
        this.partitions = queue.getPartitions();
        this.duplicateMsgToAllPartitions = queue.isDuplicateMsgToAllPartitions();
    }

    public QueueRoutingInfo(TransportProtos.GetQueueRoutingInfoResponseMsg routingInfo) {
        this.tenantId = TenantId.fromUUID((UUID)new UUID(routingInfo.getTenantIdMSB(), routingInfo.getTenantIdLSB()));
        this.queueId = new QueueId(new UUID(routingInfo.getQueueIdMSB(), routingInfo.getQueueIdLSB()));
        this.queueName = routingInfo.getQueueName();
        this.queueTopic = routingInfo.getQueueTopic();
        this.partitions = routingInfo.getPartitions();
        this.duplicateMsgToAllPartitions = routingInfo.hasDuplicateMsgToAllPartitions() && routingInfo.getDuplicateMsgToAllPartitions();
    }

    public QueueRoutingInfo(TransportProtos.QueueUpdateMsg queueUpdateMsg) {
        this.tenantId = TenantId.fromUUID((UUID)new UUID(queueUpdateMsg.getTenantIdMSB(), queueUpdateMsg.getTenantIdLSB()));
        this.queueId = new QueueId(new UUID(queueUpdateMsg.getQueueIdMSB(), queueUpdateMsg.getQueueIdLSB()));
        this.queueName = queueUpdateMsg.getQueueName();
        this.queueTopic = queueUpdateMsg.getQueueTopic();
        this.partitions = queueUpdateMsg.getPartitions();
        this.duplicateMsgToAllPartitions = queueUpdateMsg.hasDuplicateMsgToAllPartitions() && queueUpdateMsg.getDuplicateMsgToAllPartitions();
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public QueueId getQueueId() {
        return this.queueId;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public String getQueueTopic() {
        return this.queueTopic;
    }

    @Generated
    public int getPartitions() {
        return this.partitions;
    }

    @Generated
    public boolean isDuplicateMsgToAllPartitions() {
        return this.duplicateMsgToAllPartitions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueRoutingInfo)) {
            return false;
        }
        QueueRoutingInfo other = (QueueRoutingInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPartitions() != other.getPartitions()) {
            return false;
        }
        if (this.isDuplicateMsgToAllPartitions() != other.isDuplicateMsgToAllPartitions()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        QueueId this$queueId = this.getQueueId();
        QueueId other$queueId = other.getQueueId();
        if (this$queueId == null ? other$queueId != null : !this$queueId.equals(other$queueId)) {
            return false;
        }
        String this$queueName = this.getQueueName();
        String other$queueName = other.getQueueName();
        if (this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName)) {
            return false;
        }
        String this$queueTopic = this.getQueueTopic();
        String other$queueTopic = other.getQueueTopic();
        return !(this$queueTopic == null ? other$queueTopic != null : !this$queueTopic.equals(other$queueTopic));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueueRoutingInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartitions();
        result = result * 59 + (this.isDuplicateMsgToAllPartitions() ? 79 : 97);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        QueueId $queueId = this.getQueueId();
        result = result * 59 + ($queueId == null ? 43 : $queueId.hashCode());
        String $queueName = this.getQueueName();
        result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
        String $queueTopic = this.getQueueTopic();
        result = result * 59 + ($queueTopic == null ? 43 : $queueTopic.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QueueRoutingInfo(tenantId=" + String.valueOf(this.getTenantId()) + ", queueId=" + String.valueOf(this.getQueueId()) + ", queueName=" + this.getQueueName() + ", queueTopic=" + this.getQueueTopic() + ", partitions=" + this.getPartitions() + ", duplicateMsgToAllPartitions=" + this.isDuplicateMsgToAllPartitions() + ")";
    }
}

