/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.discovery;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.exception.TenantNotFoundException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.QueueKey;
import org.thingsboard.server.queue.discovery.QueueRoutingInfo;
import org.thingsboard.server.queue.discovery.QueueRoutingInfoService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.discovery.TenantRoutingInfo;
import org.thingsboard.server.queue.discovery.TenantRoutingInfoService;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.discovery.event.ClusterTopologyChangeEvent;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;
import org.thingsboard.server.queue.discovery.event.ServiceListChangedEvent;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.PropertyUtils;

@Service
public class HashPartitionService
implements PartitionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HashPartitionService.class);
    @Value(value="${queue.core.topic:tb_core}")
    private String coreTopic;
    @Value(value="${queue.core.partitions:10}")
    private Integer corePartitions;
    @Value(value="${queue.calculated_fields.event_topic:tb_cf_event}")
    private String cfEventTopic;
    @Value(value="${queue.calculated_fields.state_topic:tb_cf_state}")
    private String cfStateTopic;
    @Value(value="${queue.vc.topic:tb_version_control}")
    private String vcTopic;
    @Value(value="${queue.vc.partitions:10}")
    private Integer vcPartitions;
    @Value(value="${queue.edge.topic:tb_edge}")
    private String edgeTopic;
    @Value(value="${queue.edge.partitions:10}")
    private Integer edgePartitions;
    @Value(value="${queue.edqs.partitions:12}")
    private Integer edqsPartitions;
    @Value(value="${queue.tasks.partitions:12}")
    private Integer defaultTasksPartitions;
    @Value(value="${queue.tasks.partitions_per_type:}")
    private String tasksPartitionsPerType;
    @Value(value="${queue.partitions.hash_function_name:murmur3_128}")
    private String hashFunctionName;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final Optional<TenantRoutingInfoService> tenantRoutingInfoService;
    private final Optional<QueueRoutingInfoService> queueRoutingInfoService;
    private final TopicService topicService;
    protected volatile ConcurrentMap<QueueKey, List<Integer>> myPartitions = new ConcurrentHashMap<QueueKey, List<Integer>>();
    private final ConcurrentMap<QueueKey, String> partitionTopicsMap = new ConcurrentHashMap<QueueKey, String>();
    private final ConcurrentMap<QueueKey, Integer> partitionSizesMap = new ConcurrentHashMap<QueueKey, Integer>();
    private final ConcurrentMap<QueueKey, QueueConfig> queueConfigs = new ConcurrentHashMap<QueueKey, QueueConfig>();
    private final ConcurrentMap<TenantId, TenantRoutingInfo> tenantRoutingInfoMap = new ConcurrentHashMap<TenantId, TenantRoutingInfo>();
    private List<TransportProtos.ServiceInfo> currentOtherServices;
    private final Map<String, List<TransportProtos.ServiceInfo>> tbTransportServicesByType = new HashMap<String, List<TransportProtos.ServiceInfo>>();
    private volatile Map<TenantProfileId, List<TransportProtos.ServiceInfo>> responsibleServices = Collections.emptyMap();
    private HashFunction hashFunction;

    @PostConstruct
    public void init() {
        this.hashFunction = HashPartitionService.forName(this.hashFunctionName);
        QueueKey coreKey = new QueueKey(ServiceType.TB_CORE);
        this.partitionSizesMap.put(coreKey, this.corePartitions);
        this.partitionTopicsMap.put(coreKey, this.coreTopic);
        QueueKey vcKey = new QueueKey(ServiceType.TB_VC_EXECUTOR);
        this.partitionSizesMap.put(vcKey, this.vcPartitions);
        this.partitionTopicsMap.put(vcKey, this.vcTopic);
        if (!this.isTransport(this.serviceInfoProvider.getServiceType())) {
            this.doInitRuleEnginePartitions();
        }
        QueueKey edgeKey = coreKey.withQueueName("Edge");
        this.partitionSizesMap.put(edgeKey, this.edgePartitions);
        this.partitionTopicsMap.put(edgeKey, this.edgeTopic);
        QueueKey edqsKey = new QueueKey(ServiceType.EDQS);
        this.partitionSizesMap.put(edqsKey, this.edqsPartitions);
        this.partitionTopicsMap.put(edqsKey, "edqs");
        EnumMap<JobType, Integer> tasksPartitions = new EnumMap<JobType, Integer>(JobType.class);
        PropertyUtils.getProps(this.tasksPartitionsPerType).forEach((type, partitions) -> tasksPartitions.put(JobType.valueOf((String)type), Integer.parseInt(partitions)));
        for (JobType type2 : JobType.values()) {
            tasksPartitions.putIfAbsent(type2, this.defaultTasksPartitions);
        }
        tasksPartitions.forEach((type, partitions) -> {
            QueueKey queueKey = new QueueKey(ServiceType.TASK_PROCESSOR, type.name());
            this.partitionSizesMap.put(queueKey, (Integer)partitions);
            this.partitionTopicsMap.put(queueKey, type.getTasksTopic());
        });
    }

    @AfterStartUp(order=1)
    public void partitionsInit() {
        if (this.isTransport(this.serviceInfoProvider.getServiceType())) {
            this.doInitRuleEnginePartitions();
        }
    }

    @Override
    public List<Integer> getMyPartitions(QueueKey queueKey) {
        return (List)this.myPartitions.get(queueKey);
    }

    @Override
    public String getTopic(QueueKey queueKey) {
        return this.topicService.buildTopicName((String)this.partitionTopicsMap.get(queueKey));
    }

    private void doInitRuleEnginePartitions() {
        List<QueueRoutingInfo> queueRoutingInfoList = this.getQueueRoutingInfos();
        queueRoutingInfoList.forEach(queue -> {
            QueueKey queueKey = new QueueKey(ServiceType.TB_RULE_ENGINE, (QueueRoutingInfo)queue);
            this.updateQueue(queueKey, queue.getQueueTopic(), queue.getPartitions());
            this.queueConfigs.put(queueKey, new QueueConfig((QueueRoutingInfo)queue));
        });
    }

    private List<QueueRoutingInfo> getQueueRoutingInfos() {
        List<QueueRoutingInfo> queueRoutingInfoList;
        block7: {
            if (this.queueRoutingInfoService.isEmpty()) {
                return Collections.emptyList();
            }
            String serviceType = this.serviceInfoProvider.getServiceType();
            if (this.isTransport(serviceType)) {
                int getQueuesRetries = 10;
                while (getQueuesRetries > 0) {
                    log.info("Try to get queue routing info.");
                    try {
                        queueRoutingInfoList = this.queueRoutingInfoService.get().getAllQueuesRoutingInfo();
                        break block7;
                    }
                    catch (Exception e) {
                        log.info("Failed to get queues routing info: {}!", (Object)e.getMessage());
                        --getQueuesRetries;
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e2) {
                            log.info("Failed to await queues routing info!", (Throwable)e2);
                        }
                    }
                }
                throw new RuntimeException("Failed to await queues routing info!");
            }
            queueRoutingInfoList = this.queueRoutingInfoService.get().getAllQueuesRoutingInfo();
        }
        return queueRoutingInfoList;
    }

    private boolean isTransport(String serviceType) {
        return "tb-transport".equals(serviceType);
    }

    @Override
    public void updateQueues(List<TransportProtos.QueueUpdateMsg> queueUpdateMsgs) {
        for (TransportProtos.QueueUpdateMsg queueUpdateMsg : queueUpdateMsgs) {
            QueueRoutingInfo queueRoutingInfo = new QueueRoutingInfo(queueUpdateMsg);
            TenantId tenantId = queueRoutingInfo.getTenantId();
            QueueKey queueKey = new QueueKey(ServiceType.TB_RULE_ENGINE, queueRoutingInfo.getQueueName(), tenantId);
            this.updateQueue(queueKey, queueRoutingInfo.getQueueTopic(), queueRoutingInfo.getPartitions());
            this.queueConfigs.put(queueKey, new QueueConfig(queueRoutingInfo));
            if (tenantId.isSysTenantId()) continue;
            this.tenantRoutingInfoMap.remove(tenantId);
        }
    }

    @Override
    public void removeQueues(List<TransportProtos.QueueDeleteMsg> queueDeleteMsgs) {
        List queueKeys = queueDeleteMsgs.stream().flatMap(queueDeleteMsg -> {
            TenantId tenantId = TenantId.fromUUID((UUID)new UUID(queueDeleteMsg.getTenantIdMSB(), queueDeleteMsg.getTenantIdLSB()));
            QueueKey queueKey = new QueueKey(ServiceType.TB_RULE_ENGINE, queueDeleteMsg.getQueueName(), tenantId);
            if (queueKey.getQueueName().equals("Main")) {
                return Stream.of(queueKey, queueKey.withQueueName("CalculatedFields"), queueKey.withQueueName("CalculatedFieldStates"));
            }
            return Stream.of(queueKey);
        }).toList();
        queueKeys.forEach(queueKey -> {
            this.removeQueue((QueueKey)queueKey);
            this.evictTenantInfo(queueKey.getTenantId());
        });
        if (this.serviceInfoProvider.isService(ServiceType.TB_RULE_ENGINE)) {
            this.publishPartitionChangeEvent(ServiceType.TB_RULE_ENGINE, queueKeys.stream().collect(Collectors.toMap(k -> k, k -> Collections.emptySet())), Collections.emptyMap());
        }
    }

    @Override
    public void removeTenant(TenantId tenantId) {
        List queueKeys = this.partitionSizesMap.keySet().stream().filter(queueKey -> tenantId.equals((Object)queueKey.getTenantId())).flatMap(queueKey -> {
            if (queueKey.getQueueName().equals("Main")) {
                return Stream.of(queueKey, queueKey.withQueueName("CalculatedFields"), queueKey.withQueueName("CalculatedFieldStates"));
            }
            return Stream.of(queueKey);
        }).toList();
        queueKeys.forEach(this::removeQueue);
        this.evictTenantInfo(tenantId);
    }

    private void updateQueue(QueueKey queueKey, String topic, int partitions) {
        this.partitionTopicsMap.put(queueKey, topic);
        this.partitionSizesMap.put(queueKey, partitions);
        if ("Main".equals(queueKey.getQueueName())) {
            QueueKey cfQueueKey = queueKey.withQueueName("CalculatedFields");
            this.partitionTopicsMap.put(cfQueueKey, this.cfEventTopic);
            this.partitionSizesMap.put(cfQueueKey, partitions);
            QueueKey cfStatesQueueKey = queueKey.withQueueName("CalculatedFieldStates");
            this.partitionTopicsMap.put(cfStatesQueueKey, this.cfStateTopic);
            this.partitionSizesMap.put(cfStatesQueueKey, partitions);
        }
    }

    private void removeQueue(QueueKey queueKey) {
        this.myPartitions.remove(queueKey);
        this.partitionTopicsMap.remove(queueKey);
        this.partitionSizesMap.remove(queueKey);
        this.queueConfigs.remove(queueKey);
    }

    @Override
    public boolean isManagedByCurrentService(TenantId tenantId) {
        if (this.serviceInfoProvider.isService(ServiceType.TB_CORE) || !this.serviceInfoProvider.isService(ServiceType.TB_RULE_ENGINE)) {
            return true;
        }
        Set assignedTenantProfiles = this.serviceInfoProvider.getAssignedTenantProfiles();
        boolean isRegular = assignedTenantProfiles.isEmpty();
        if (tenantId.isSysTenantId()) {
            return isRegular;
        }
        TenantRoutingInfo routingInfo = this.getRoutingInfo(tenantId);
        boolean isManaged = isRegular ? (routingInfo.isIsolated() ? this.hasDedicatedService(routingInfo.getProfileId()) : true) : (routingInfo.isIsolated() ? assignedTenantProfiles.contains(routingInfo.getProfileId().getId()) : false);
        log.trace("[{}] Tenant {} managed by this service", (Object)tenantId, (Object)(isManaged ? "is" : "is not"));
        return isManaged;
    }

    private boolean hasDedicatedService(TenantProfileId profileId) {
        return CollectionsUtil.isEmpty((Collection)this.responsibleServices.get(profileId));
    }

    @Override
    public TopicPartitionInfo resolve(ServiceType serviceType, String queueName, TenantId tenantId, EntityId entityId) {
        QueueKey queueKey = this.getQueueKey(serviceType, queueName, tenantId);
        return this.resolve(queueKey, entityId);
    }

    @Override
    public TopicPartitionInfo resolve(ServiceType serviceType, String queueName, TenantId tenantId, EntityId entityId, Integer partition) {
        QueueKey queueKey = this.getQueueKey(serviceType, queueName, tenantId);
        if (partition != null) {
            return this.buildTopicPartitionInfo(queueKey, partition);
        }
        return this.resolve(queueKey, entityId);
    }

    @Override
    public TopicPartitionInfo resolve(ServiceType serviceType, TenantId tenantId, EntityId entityId) {
        return this.resolve(serviceType, null, tenantId, entityId);
    }

    @Override
    public List<TopicPartitionInfo> resolveAll(ServiceType serviceType, String queueName, TenantId tenantId, EntityId entityId) {
        QueueKey queueKey = this.getQueueKey(serviceType, queueName, tenantId);
        TopicPartitionInfo tpi = this.resolve(queueKey, entityId);
        if (serviceType != ServiceType.TB_RULE_ENGINE || tpi.getPartition().isEmpty()) {
            return List.of(tpi);
        }
        QueueConfig queueConfig = (QueueConfig)this.queueConfigs.get(queueKey);
        if (queueConfig != null && queueConfig.isDuplicateMsgToAllPartitions()) {
            int partition = (Integer)tpi.getPartition().get();
            Integer partitionsCount = (Integer)this.partitionSizesMap.get(queueKey);
            ArrayList<TopicPartitionInfo> partitions = new ArrayList<TopicPartitionInfo>(partitionsCount);
            partitions.add(tpi);
            for (int i = 0; i < partitionsCount; ++i) {
                if (i == partition) continue;
                partitions.add(this.buildTopicPartitionInfo(queueKey, i, false));
            }
            return partitions;
        }
        return Collections.singletonList(tpi);
    }

    private TopicPartitionInfo resolve(QueueKey queueKey, EntityId entityId) {
        Integer partitionSize = (Integer)this.partitionSizesMap.get(queueKey);
        if (partitionSize == null) {
            throw new IllegalStateException("Partitions info for queue " + String.valueOf(queueKey) + " is missing");
        }
        int hash = this.hash(entityId.getId());
        int partition = Math.abs(hash % partitionSize);
        return this.buildTopicPartitionInfo(queueKey, partition);
    }

    private QueueKey getQueueKey(ServiceType serviceType, String queueName, TenantId tenantId) {
        QueueKey queueKey;
        TenantId isolatedOrSystemTenantId = this.getIsolatedOrSystemTenantId(serviceType, tenantId);
        if (queueName == null || queueName.isEmpty()) {
            queueName = "Main";
        }
        if (!this.partitionSizesMap.containsKey(queueKey = new QueueKey(serviceType, queueName, isolatedOrSystemTenantId))) {
            if (isolatedOrSystemTenantId.isSysTenantId()) {
                queueKey = new QueueKey(serviceType, TenantId.SYS_TENANT_ID);
            } else {
                queueKey = new QueueKey(serviceType, queueName, TenantId.SYS_TENANT_ID);
                if (!"Main".equals(queueName) && !this.partitionSizesMap.containsKey(queueKey)) {
                    queueKey = new QueueKey(serviceType, TenantId.SYS_TENANT_ID);
                }
                log.warn("Using queue {} instead of isolated {} for tenant {}", new Object[]{queueKey, queueName, isolatedOrSystemTenantId});
            }
        }
        return queueKey;
    }

    @Override
    public boolean isMyPartition(ServiceType serviceType, TenantId tenantId, EntityId entityId) {
        try {
            return this.resolve(serviceType, tenantId, entityId).isMyPartition();
        }
        catch (TenantNotFoundException e) {
            log.warn("Tenant with id {} not found", (Object)tenantId, (Object)new RuntimeException("stacktrace"));
            return false;
        }
    }

    @Override
    public boolean isSystemPartitionMine(ServiceType serviceType) {
        return this.isMyPartition(serviceType, TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID);
    }

    @Override
    public synchronized void recalculatePartitions(TransportProtos.ServiceInfo currentService, List<TransportProtos.ServiceInfo> otherServices) {
        log.info("Recalculating partitions");
        this.tbTransportServicesByType.clear();
        this.logServiceInfo(currentService);
        otherServices.forEach(this::logServiceInfo);
        HashMap<QueueKey, List<TransportProtos.ServiceInfo>> queueServicesMap = new HashMap<QueueKey, List<TransportProtos.ServiceInfo>>();
        HashMap<TenantProfileId, List<TransportProtos.ServiceInfo>> responsibleServices = new HashMap<TenantProfileId, List<TransportProtos.ServiceInfo>>();
        this.addNode(currentService, queueServicesMap, responsibleServices);
        for (TransportProtos.ServiceInfo other : otherServices) {
            this.addNode(other, queueServicesMap, responsibleServices);
        }
        queueServicesMap.values().forEach(list -> list.sort(Comparator.comparing(TransportProtos.ServiceInfo::getServiceId)));
        responsibleServices.values().forEach(list -> list.sort(Comparator.comparing(TransportProtos.ServiceInfo::getServiceId)));
        ConcurrentHashMap<QueueKey, List<Integer>> newPartitions = new ConcurrentHashMap<QueueKey, List<Integer>>();
        this.partitionSizesMap.forEach((queueKey, size) -> {
            for (int i = 0; i < size; ++i) {
                try {
                    List<TransportProtos.ServiceInfo> services = this.resolveByPartitionIdx((List)queueServicesMap.get(queueKey), (QueueKey)queueKey, i, (Map<TenantProfileId, List<TransportProtos.ServiceInfo>>)responsibleServices);
                    log.trace("Server responsible for {}[{}] - {}", new Object[]{queueKey, i, services});
                    if (!services.contains(currentService)) continue;
                    newPartitions.computeIfAbsent((QueueKey)queueKey, key -> new ArrayList()).add(i);
                    continue;
                }
                catch (Exception e) {
                    log.warn("Failed to resolve server responsible for {}[{}]", new Object[]{queueKey, i, e});
                }
            }
        });
        this.responsibleServices = responsibleServices;
        ConcurrentMap<QueueKey, List<Integer>> oldPartitions = this.myPartitions;
        this.myPartitions = newPartitions;
        HashMap changedPartitionsMap = new HashMap();
        HashMap oldPartitionsMap = new HashMap();
        HashSet removed = new HashSet();
        oldPartitions.forEach((queueKey, partitions) -> {
            if (!newPartitions.containsKey(queueKey)) {
                removed.add(queueKey);
            }
        });
        if (this.serviceInfoProvider.isService(ServiceType.TB_RULE_ENGINE)) {
            this.partitionSizesMap.keySet().stream().filter(queueKey -> queueKey.getType() == ServiceType.TB_RULE_ENGINE && !queueKey.getTenantId().isSysTenantId() && !newPartitions.containsKey(queueKey)).forEach(removed::add);
        }
        removed.forEach(queueKey -> changedPartitionsMap.put(queueKey, Collections.emptySet()));
        this.myPartitions.forEach((queueKey, partitions) -> {
            if (!partitions.equals(oldPartitions.get(queueKey))) {
                changedPartitionsMap.put(queueKey, this.toTpiList((QueueKey)queueKey, (List<Integer>)partitions));
                oldPartitionsMap.put(queueKey, this.toTpiList((QueueKey)queueKey, (List)oldPartitions.get(queueKey)));
            }
        });
        if (!changedPartitionsMap.isEmpty()) {
            changedPartitionsMap.entrySet().stream().collect(Collectors.groupingBy(entry -> ((QueueKey)entry.getKey()).getType(), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).forEach((serviceType, partitionsMap) -> this.publishPartitionChangeEvent((ServiceType)serviceType, (Map<QueueKey, Set<TopicPartitionInfo>>)partitionsMap, oldPartitionsMap));
        }
        if (this.currentOtherServices == null) {
            this.currentOtherServices = new ArrayList<TransportProtos.ServiceInfo>(otherServices);
        } else {
            HashSet<QueueKey> changes = new HashSet<QueueKey>();
            Map<QueueKey, List<TransportProtos.ServiceInfo>> currentMap = this.getServiceKeyListMap(this.currentOtherServices);
            Map<QueueKey, List<TransportProtos.ServiceInfo>> newMap = this.getServiceKeyListMap(otherServices);
            this.currentOtherServices = otherServices;
            currentMap.forEach((key, list) -> {
                if (!list.equals(newMap.get(key))) {
                    changes.add((QueueKey)key);
                }
            });
            currentMap.keySet().forEach(newMap::remove);
            changes.addAll(newMap.keySet());
            if (!changes.isEmpty()) {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new ClusterTopologyChangeEvent(this, changes));
                responsibleServices.forEach((profileId, serviceInfos) -> {
                    if (profileId != null) {
                        log.info("Servers responsible for tenant profile {}: {}", profileId, this.toServiceIds((Collection<TransportProtos.ServiceInfo>)serviceInfos));
                    } else {
                        log.info("Servers responsible for system queues: {}", this.toServiceIds((Collection<TransportProtos.ServiceInfo>)serviceInfos));
                    }
                });
            }
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ServiceListChangedEvent(otherServices, currentService));
    }

    private void publishPartitionChangeEvent(ServiceType serviceType, Map<QueueKey, Set<TopicPartitionInfo>> newPartitions, Map<QueueKey, Set<TopicPartitionInfo>> oldPartitions) {
        log.info("Partitions changed: {}", (Object)(System.lineSeparator() + newPartitions.entrySet().stream().map(entry -> "[" + String.valueOf(entry.getKey()) + "] - [" + ((Set)entry.getValue()).stream().map(tpi -> tpi.getPartition().orElse(-1).toString()).sorted().collect(Collectors.joining(", ")) + "]").collect(Collectors.joining(System.lineSeparator()))));
        PartitionChangeEvent event = new PartitionChangeEvent(this, serviceType, newPartitions, oldPartitions);
        try {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            log.error("Failed to publish partition change event {}", (Object)event, (Object)e);
        }
    }

    private Set<TopicPartitionInfo> toTpiList(QueueKey queueKey, List<Integer> partitions) {
        if (partitions == null) {
            return Collections.emptySet();
        }
        return partitions.stream().map(partition -> this.buildTopicPartitionInfo(queueKey, (int)partition)).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getAllServiceIds(ServiceType serviceType) {
        return this.getAllServices(serviceType).stream().map(TransportProtos.ServiceInfo::getServiceId).collect(Collectors.toSet());
    }

    @Override
    public Set<TransportProtos.ServiceInfo> getAllServices(ServiceType serviceType) {
        Set<TransportProtos.ServiceInfo> result = this.getOtherServices(serviceType);
        TransportProtos.ServiceInfo current = this.serviceInfoProvider.getServiceInfo();
        if (current.getServiceTypesList().contains((Object)serviceType.name())) {
            result.add(current);
        }
        return result;
    }

    @Override
    public Set<TransportProtos.ServiceInfo> getOtherServices(ServiceType serviceType) {
        HashSet<TransportProtos.ServiceInfo> result = new HashSet<TransportProtos.ServiceInfo>();
        if (this.currentOtherServices != null) {
            for (TransportProtos.ServiceInfo serviceInfo : this.currentOtherServices) {
                if (!serviceInfo.getServiceTypesList().contains((Object)serviceType.name())) continue;
                result.add(serviceInfo);
            }
        }
        return result;
    }

    @Override
    public int resolvePartitionIndex(UUID entityId, int partitions) {
        return this.resolvePartitionIndex(this.hash(entityId), partitions);
    }

    @Override
    public int resolvePartitionIndex(String key, int partitions) {
        return this.resolvePartitionIndex(this.hash(key), partitions);
    }

    private int resolvePartitionIndex(int hash, int partitions) {
        return Math.abs(hash % partitions);
    }

    @Override
    public void evictTenantInfo(TenantId tenantId) {
        this.tenantRoutingInfoMap.remove(tenantId);
    }

    @Override
    public int countTransportsByType(String type) {
        List<TransportProtos.ServiceInfo> list = this.tbTransportServicesByType.get(type);
        return list == null ? 0 : list.size();
    }

    private Map<QueueKey, List<TransportProtos.ServiceInfo>> getServiceKeyListMap(List<TransportProtos.ServiceInfo> services) {
        HashMap<QueueKey, List<TransportProtos.ServiceInfo>> currentMap = new HashMap<QueueKey, List<TransportProtos.ServiceInfo>>();
        services.forEach(serviceInfo -> {
            for (String serviceTypeStr : serviceInfo.getServiceTypesList()) {
                ServiceType serviceType = ServiceType.of((String)serviceTypeStr);
                if (ServiceType.TB_RULE_ENGINE.equals((Object)serviceType)) {
                    this.partitionTopicsMap.keySet().forEach(queueKey -> currentMap.computeIfAbsent((QueueKey)queueKey, key -> new ArrayList()).add(serviceInfo));
                    continue;
                }
                QueueKey queueKey2 = new QueueKey(serviceType);
                currentMap.computeIfAbsent(queueKey2, key -> new ArrayList()).add(serviceInfo);
            }
        });
        return currentMap;
    }

    private TopicPartitionInfo buildTopicPartitionInfo(QueueKey queueKey, int partition) {
        List partitions = (List)this.myPartitions.get(queueKey);
        return this.buildTopicPartitionInfo(queueKey, partition, partitions != null && partitions.contains(partition));
    }

    private TopicPartitionInfo buildTopicPartitionInfo(QueueKey queueKey, int partition, boolean myPartition) {
        return TopicPartitionInfo.builder().topic(this.topicService.buildTopicName((String)this.partitionTopicsMap.get(queueKey))).partition(Integer.valueOf(partition)).tenantId(queueKey.getTenantId()).myPartition(myPartition).build();
    }

    private boolean isIsolated(ServiceType serviceType, TenantId tenantId) {
        if (TenantId.SYS_TENANT_ID.equals((Object)tenantId)) {
            return false;
        }
        TenantRoutingInfo routingInfo = this.getRoutingInfo(tenantId);
        if (routingInfo == null) {
            throw new TenantNotFoundException(tenantId);
        }
        if (serviceType == ServiceType.TB_RULE_ENGINE) {
            return routingInfo.isIsolated();
        }
        return false;
    }

    private TenantRoutingInfo getRoutingInfo(TenantId tenantId) {
        if (this.tenantRoutingInfoService.isPresent()) {
            return this.tenantRoutingInfoMap.computeIfAbsent(tenantId, __ -> this.tenantRoutingInfoService.get().getRoutingInfo(tenantId));
        }
        return new TenantRoutingInfo(tenantId, null, false);
    }

    protected TenantId getIsolatedOrSystemTenantId(ServiceType serviceType, TenantId tenantId) {
        return this.isIsolated(serviceType, tenantId) ? tenantId : TenantId.SYS_TENANT_ID;
    }

    private void logServiceInfo(TransportProtos.ServiceInfo server) {
        log.info("[{}] Found common server: {}", (Object)server.getServiceId(), (Object)server.getServiceTypesList());
    }

    private void addNode(TransportProtos.ServiceInfo instance, Map<QueueKey, List<TransportProtos.ServiceInfo>> queueServiceList, Map<TenantProfileId, List<TransportProtos.ServiceInfo>> responsibleServices) {
        for (String serviceTypeStr : instance.getServiceTypesList()) {
            ServiceType serviceType = ServiceType.of((String)serviceTypeStr);
            if (ServiceType.TB_RULE_ENGINE.equals((Object)serviceType)) {
                this.partitionTopicsMap.keySet().forEach(key -> {
                    if (key.getType().equals((Object)ServiceType.TB_RULE_ENGINE)) {
                        queueServiceList.computeIfAbsent((QueueKey)key, k -> new ArrayList()).add(instance);
                    }
                });
                if (instance.getAssignedTenantProfilesCount() <= 0) continue;
                for (String profileIdStr : instance.getAssignedTenantProfilesList()) {
                    TenantProfileId profileId;
                    try {
                        profileId = new TenantProfileId(UUID.fromString(profileIdStr));
                    }
                    catch (IllegalArgumentException e) {
                        log.warn("Failed to parse '{}' as tenant profile id", (Object)profileIdStr);
                        continue;
                    }
                    responsibleServices.computeIfAbsent(profileId, k -> new ArrayList()).add(instance);
                }
                continue;
            }
            if (ServiceType.TB_CORE.equals((Object)serviceType)) {
                queueServiceList.computeIfAbsent(new QueueKey(serviceType), key -> new ArrayList()).add(instance);
                queueServiceList.computeIfAbsent(new QueueKey(serviceType).withQueueName("Edge"), key -> new ArrayList()).add(instance);
                continue;
            }
            if (ServiceType.TB_VC_EXECUTOR.equals((Object)serviceType)) {
                queueServiceList.computeIfAbsent(new QueueKey(serviceType), key -> new ArrayList()).add(instance);
                continue;
            }
            if (!ServiceType.EDQS.equals((Object)serviceType)) continue;
            queueServiceList.computeIfAbsent(new QueueKey(serviceType), key -> new ArrayList()).add(instance);
        }
        for (String transportType : instance.getTransportsList()) {
            this.tbTransportServicesByType.computeIfAbsent(transportType, t -> new ArrayList()).add(instance);
        }
        for (String taskType : instance.getTaskTypesList()) {
            QueueKey queueKey = new QueueKey(ServiceType.TASK_PROCESSOR, taskType);
            queueServiceList.computeIfAbsent(queueKey, key -> new ArrayList()).add(instance);
        }
    }

    @NotNull
    protected List<TransportProtos.ServiceInfo> resolveByPartitionIdx(List<TransportProtos.ServiceInfo> servers, QueueKey queueKey, int partition, Map<TenantProfileId, List<TransportProtos.ServiceInfo>> responsibleServices) {
        if (servers == null || servers.isEmpty()) {
            return Collections.emptyList();
        }
        TenantId tenantId = queueKey.getTenantId();
        if (queueKey.getType() == ServiceType.TB_RULE_ENGINE) {
            int hash;
            TransportProtos.ServiceInfo server;
            if (!responsibleServices.isEmpty()) {
                TenantProfileId profileId;
                if (tenantId != null && !tenantId.isSysTenantId()) {
                    TenantRoutingInfo routingInfo = this.tenantRoutingInfoService.get().getRoutingInfo(tenantId);
                    profileId = routingInfo.getProfileId();
                } else {
                    profileId = null;
                }
                List<Object> responsible = responsibleServices.get(profileId);
                if (responsible == null) {
                    responsible = servers.stream().filter(serviceInfo -> serviceInfo.getAssignedTenantProfilesCount() == 0).sorted(Comparator.comparing(TransportProtos.ServiceInfo::getServiceId)).collect(Collectors.toList());
                    if (profileId != null) {
                        log.debug("Using servers {} for profile {}", this.toServiceIds(responsible), (Object)profileId);
                    }
                    responsibleServices.put(profileId, responsible);
                }
                if (responsible.isEmpty()) {
                    return Collections.emptyList();
                }
                servers = responsible;
            }
            return (server = servers.get(Math.abs(((hash = this.hash(tenantId.getId())) + partition) % servers.size()))) != null ? List.of(server) : Collections.emptyList();
        }
        if (queueKey.getType() == ServiceType.EDQS) {
            List<List> sets = servers.stream().collect(Collectors.groupingBy(TransportProtos.ServiceInfo::getLabel)).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).toList();
            return sets.get(partition % sets.size());
        }
        TransportProtos.ServiceInfo server = servers.get(partition % servers.size());
        return server != null ? List.of(server) : Collections.emptyList();
    }

    private int hash(UUID key) {
        return this.hashFunction.newHasher().putLong(key.getMostSignificantBits()).putLong(key.getLeastSignificantBits()).hash().asInt();
    }

    private int hash(String key) {
        return this.hashFunction.newHasher().putString((CharSequence)key, StandardCharsets.UTF_8).hash().asInt();
    }

    public static HashFunction forName(String name) {
        return switch (name) {
            case "murmur3_32" -> Hashing.murmur3_32();
            case "murmur3_128" -> Hashing.murmur3_128();
            case "sha256" -> Hashing.sha256();
            default -> throw new IllegalArgumentException("Can't find hash function with name " + name);
        };
    }

    private List<String> toServiceIds(Collection<TransportProtos.ServiceInfo> serviceInfos) {
        return serviceInfos.stream().map(TransportProtos.ServiceInfo::getServiceId).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"applicationEventPublisher", "serviceInfoProvider", "tenantRoutingInfoService", "queueRoutingInfoService", "topicService"})
    @Generated
    public HashPartitionService(ApplicationEventPublisher applicationEventPublisher, TbServiceInfoProvider serviceInfoProvider, Optional<TenantRoutingInfoService> tenantRoutingInfoService, Optional<QueueRoutingInfoService> queueRoutingInfoService, TopicService topicService) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.serviceInfoProvider = serviceInfoProvider;
        this.tenantRoutingInfoService = tenantRoutingInfoService;
        this.queueRoutingInfoService = queueRoutingInfoService;
        this.topicService = topicService;
    }

    public static class QueueConfig {
        private boolean duplicateMsgToAllPartitions;

        public QueueConfig(QueueRoutingInfo queueRoutingInfo) {
            this.duplicateMsgToAllPartitions = queueRoutingInfo.isDuplicateMsgToAllPartitions();
        }

        @Generated
        public boolean isDuplicateMsgToAllPartitions() {
            return this.duplicateMsgToAllPartitions;
        }

        @Generated
        public void setDuplicateMsgToAllPartitions(boolean duplicateMsgToAllPartitions) {
            this.duplicateMsgToAllPartitions = duplicateMsgToAllPartitions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueueConfig)) {
                return false;
            }
            QueueConfig other = (QueueConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isDuplicateMsgToAllPartitions() == other.isDuplicateMsgToAllPartitions();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof QueueConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDuplicateMsgToAllPartitions() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "HashPartitionService.QueueConfig(duplicateMsgToAllPartitions=" + this.isDuplicateMsgToAllPartitions() + ")";
        }
    }
}

