/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.common.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.common.consumer.PartitionedQueueConsumerManager;
import org.thingsboard.server.queue.discovery.QueueKey;

public abstract class QueueStateService<E extends TbQueueMsg, S extends TbQueueMsg> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueueStateService.class);
    protected final PartitionedQueueConsumerManager<E> eventConsumer;
    protected final List<PartitionedQueueConsumerManager<?>> otherConsumers;
    protected final Map<QueueKey, Set<TopicPartitionInfo>> partitions = new HashMap<QueueKey, Set<TopicPartitionInfo>>();
    protected final ReadWriteLock partitionsLock = new ReentrantReadWriteLock();

    protected QueueStateService(PartitionedQueueConsumerManager<E> eventConsumer, List<PartitionedQueueConsumerManager<?>> otherConsumers) {
        this.eventConsumer = eventConsumer;
        this.otherConsumers = otherConsumers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(QueueKey queueKey, Set<TopicPartitionInfo> newPartitions, Runnable whenAllProcessed) {
        HashSet<TopicPartitionInfo> removedPartitions;
        HashSet<TopicPartitionInfo> addedPartitions;
        newPartitions = TopicPartitionInfo.withTopic(newPartitions, (String)this.eventConsumer.getTopic());
        Lock writeLock = this.partitionsLock.writeLock();
        writeLock.lock();
        Set oldPartitions = this.partitions.getOrDefault(queueKey, Collections.emptySet());
        try {
            addedPartitions = new HashSet<TopicPartitionInfo>(newPartitions);
            addedPartitions.removeAll(oldPartitions);
            removedPartitions = new HashSet<TopicPartitionInfo>(oldPartitions);
            removedPartitions.removeAll(newPartitions);
            this.partitions.put(queueKey, newPartitions);
        }
        finally {
            writeLock.unlock();
        }
        if (!removedPartitions.isEmpty()) {
            this.removePartitions(queueKey, removedPartitions);
        }
        if (!addedPartitions.isEmpty()) {
            this.addPartitions(queueKey, addedPartitions, whenAllProcessed);
        } else if (whenAllProcessed != null) {
            whenAllProcessed.run();
        }
    }

    protected void addPartitions(QueueKey queueKey, Set<TopicPartitionInfo> partitions, Runnable whenAllProcessed) {
        if (whenAllProcessed != null) {
            whenAllProcessed.run();
        }
        this.eventConsumer.addPartitions(partitions);
        for (PartitionedQueueConsumerManager<?> consumer : this.otherConsumers) {
            consumer.addPartitions(TopicPartitionInfo.withTopic(partitions, (String)consumer.getTopic()));
        }
    }

    protected void removePartitions(QueueKey queueKey, Set<TopicPartitionInfo> partitions) {
        this.eventConsumer.removePartitions(partitions);
        for (PartitionedQueueConsumerManager<?> consumer : this.otherConsumers) {
            consumer.removePartitions(TopicPartitionInfo.withTopic(partitions, (String)consumer.getTopic()));
        }
    }

    public void delete(Set<TopicPartitionInfo> partitions) {
        if (partitions.isEmpty()) {
            return;
        }
        Lock writeLock = this.partitionsLock.writeLock();
        writeLock.lock();
        try {
            this.partitions.values().forEach(tpis -> tpis.removeAll(partitions));
        }
        finally {
            writeLock.unlock();
        }
        this.deletePartitions(partitions);
    }

    protected void deletePartitions(Set<TopicPartitionInfo> partitions) {
        this.eventConsumer.delete(TopicPartitionInfo.withTopic(partitions, (String)this.eventConsumer.getTopic()));
        for (PartitionedQueueConsumerManager<?> consumer : this.otherConsumers) {
            consumer.removePartitions(TopicPartitionInfo.withTopic(partitions, (String)consumer.getTopic()));
        }
    }

    public void stop() {
        this.eventConsumer.stop();
        this.eventConsumer.awaitStop();
    }

    @Generated
    public Map<QueueKey, Set<TopicPartitionInfo>> getPartitions() {
        return this.partitions;
    }
}

