/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.common.consumer;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.thingsboard.server.common.data.queue.QueueConfig;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.queue.common.consumer.QueueTaskType;

public interface TbQueueConsumerManagerTask {
    public QueueTaskType getType();

    public record DeletePartitionsTask(Set<TopicPartitionInfo> partitions) implements TbQueueConsumerManagerTask
    {
        @Override
        public QueueTaskType getType() {
            return QueueTaskType.REMOVE_PARTITIONS;
        }
    }

    public record RemovePartitionsTask(Set<TopicPartitionInfo> partitions) implements TbQueueConsumerManagerTask
    {
        @Override
        public QueueTaskType getType() {
            return QueueTaskType.REMOVE_PARTITIONS;
        }
    }

    public record AddPartitionsTask(Set<TopicPartitionInfo> partitions, Consumer<TopicPartitionInfo> onStop, Function<String, Long> startOffsetProvider) implements TbQueueConsumerManagerTask
    {
        @Override
        public QueueTaskType getType() {
            return QueueTaskType.ADD_PARTITIONS;
        }
    }

    public record UpdatePartitionsTask(Set<TopicPartitionInfo> partitions) implements TbQueueConsumerManagerTask
    {
        @Override
        public QueueTaskType getType() {
            return QueueTaskType.UPDATE_PARTITIONS;
        }
    }

    public record UpdateConfigTask(QueueConfig config) implements TbQueueConsumerManagerTask
    {
        @Override
        public QueueTaskType getType() {
            return QueueTaskType.UPDATE_CONFIG;
        }
    }

    public record DeleteQueueTask(boolean drainQueue) implements TbQueueConsumerManagerTask
    {
        @Override
        public QueueTaskType getType() {
            return QueueTaskType.DELETE;
        }
    }
}

