/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.common;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.PartitionService;

@Service
public class TbRuleEngineProducerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbRuleEngineProducerService.class);
    private final PartitionService partitionService;

    public void sendToRuleEngine(TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> producer, TenantId tenantId, TbMsg tbMsg, TbQueueCallback callback) {
        List<TopicPartitionInfo> tpis = this.partitionService.resolveAll(ServiceType.TB_RULE_ENGINE, tbMsg.getQueueName(), tenantId, tbMsg.getOriginator());
        if (tpis.size() > 1) {
            UUID correlationId = UUID.randomUUID();
            for (int i = 0; i < tpis.size(); ++i) {
                TopicPartitionInfo tpi = tpis.get(i);
                Integer partition = tpi.getPartition().orElse(null);
                UUID id = i > 0 ? UUID.randomUUID() : tbMsg.getId();
                tbMsg = tbMsg.transform().id(id).correlationId(correlationId).partition(partition).build();
                this.sendToRuleEngine(producer, tpi, tenantId, tbMsg, (TbQueueCallback)(i == tpis.size() - 1 ? callback : null));
            }
        } else {
            this.sendToRuleEngine(producer, tpis.get(0), tenantId, tbMsg, callback);
        }
    }

    private void sendToRuleEngine(TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> producer, TopicPartitionInfo tpi, TenantId tenantId, TbMsg tbMsg, TbQueueCallback callback) {
        if (log.isTraceEnabled()) {
            log.trace("[{}][{}] Pushing to topic {} message {}", new Object[]{tenantId, tbMsg.getOriginator(), tpi.getFullTopicName(), tbMsg});
        }
        TransportProtos.ToRuleEngineMsg msg = TransportProtos.ToRuleEngineMsg.newBuilder().setTbMsgProto(TbMsg.toProto((TbMsg)tbMsg)).setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).build();
        producer.send(tpi, new TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>(tbMsg.getId(), msg), callback);
    }

    @ConstructorProperties(value={"partitionService"})
    @Generated
    public TbRuleEngineProducerService(PartitionService partitionService) {
        this.partitionService = partitionService;
    }
}

