/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.common;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.stats.MessagesStats;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueHandler;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.TbQueueResponseTemplate;
import org.thingsboard.server.queue.common.AbstractTbQueueTemplate;
import org.thingsboard.server.queue.common.AsyncCallbackTemplate;

public class DefaultTbQueueResponseTemplate<Request extends TbQueueMsg, Response extends TbQueueMsg>
extends AbstractTbQueueTemplate
implements TbQueueResponseTemplate<Request, Response> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbQueueResponseTemplate.class);
    private final TbQueueConsumer<Request> requestTemplate;
    private final TbQueueProducer<Response> responseTemplate;
    private final ExecutorService loopExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final ExecutorService callbackExecutor;
    private final MessagesStats stats;
    private final int maxPendingRequests;
    private final long requestTimeout;
    private final long pollInterval;
    private volatile boolean stopped = false;
    private final AtomicInteger pendingRequestCount = new AtomicInteger();

    public DefaultTbQueueResponseTemplate(TbQueueConsumer<Request> requestTemplate, TbQueueProducer<Response> responseTemplate, TbQueueHandler<Request, Response> handler, long pollInterval, long requestTimeout, int maxPendingRequests, ExecutorService executor, MessagesStats stats) {
        this.requestTemplate = requestTemplate;
        this.responseTemplate = responseTemplate;
        this.maxPendingRequests = maxPendingRequests;
        this.pollInterval = pollInterval;
        this.requestTimeout = requestTimeout;
        this.callbackExecutor = executor;
        this.stats = stats;
        this.timeoutExecutor = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)("tb-queue-response-template-timeout-" + requestTemplate.getTopic()));
        this.loopExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)("tb-queue-response-template-loop-" + requestTemplate.getTopic())));
    }

    public void subscribe() {
        this.requestTemplate.subscribe();
    }

    public void subscribe(Set<TopicPartitionInfo> partitions) {
        this.requestTemplate.subscribe(partitions);
    }

    public void launch(TbQueueHandler<Request, Response> handler) {
        this.loopExecutor.submit(() -> {
            while (!this.stopped) {
                try {
                    while (this.pendingRequestCount.get() >= this.maxPendingRequests) {
                        try {
                            Thread.sleep(this.pollInterval);
                        }
                        catch (InterruptedException e) {
                            log.trace("Failed to wait until the server has capacity to handle new requests", (Throwable)e);
                        }
                    }
                    List requests = this.requestTemplate.poll(this.pollInterval);
                    if (requests.isEmpty()) continue;
                    requests.forEach(request -> {
                        long currentTime = System.currentTimeMillis();
                        long expireTs = DefaultTbQueueResponseTemplate.bytesToLong(request.getHeaders().get("expireTs"));
                        if (expireTs >= currentTime) {
                            byte[] requestIdHeader = request.getHeaders().get("requestId");
                            if (requestIdHeader == null) {
                                log.error("[{}] Missing requestId in header", request);
                                return;
                            }
                            byte[] responseTopicHeader = request.getHeaders().get("responseTopic");
                            if (responseTopicHeader == null) {
                                log.error("[{}] Missing response topic in header", request);
                                return;
                            }
                            UUID requestId = DefaultTbQueueResponseTemplate.bytesToUuid(requestIdHeader);
                            String responseTopic = DefaultTbQueueResponseTemplate.bytesToString(responseTopicHeader);
                            try {
                                this.pendingRequestCount.getAndIncrement();
                                this.stats.incrementTotal();
                                AsyncCallbackTemplate.withCallbackAndTimeout(handler.handle(request), response -> {
                                    this.pendingRequestCount.decrementAndGet();
                                    response.getHeaders().put("requestId", DefaultTbQueueResponseTemplate.uuidToBytes(requestId));
                                    this.responseTemplate.send(TopicPartitionInfo.builder().topic(responseTopic).build(), response, null);
                                    this.stats.incrementSuccessful();
                                }, e -> {
                                    this.pendingRequestCount.decrementAndGet();
                                    if (e.getCause() != null && e.getCause() instanceof TimeoutException) {
                                        log.warn("[{}] Timeout to process the request: {}", new Object[]{requestId, request, e});
                                    } else {
                                        log.trace("[{}] Failed to process the request: {}", new Object[]{requestId, request, e});
                                    }
                                    this.stats.incrementFailed();
                                }, this.requestTimeout, this.timeoutExecutor, this.callbackExecutor);
                            }
                            catch (Throwable e2) {
                                this.pendingRequestCount.decrementAndGet();
                                log.warn("[{}] Failed to process the request: {}", new Object[]{requestId, request, e2});
                                this.stats.incrementFailed();
                            }
                        }
                    });
                    this.requestTemplate.commit();
                }
                catch (Throwable e) {
                    log.warn("Failed to obtain messages from queue.", e);
                    try {
                        Thread.sleep(this.pollInterval);
                    }
                    catch (InterruptedException e2) {
                        log.trace("Failed to wait until the server has capacity to handle new requests", (Throwable)e2);
                    }
                }
            }
        });
    }

    public void stop() {
        this.stopped = true;
        if (this.requestTemplate != null) {
            this.requestTemplate.unsubscribe();
        }
        if (this.responseTemplate != null) {
            this.responseTemplate.stop();
        }
        if (this.timeoutExecutor != null) {
            this.timeoutExecutor.shutdownNow();
        }
        if (this.loopExecutor != null) {
            this.loopExecutor.shutdownNow();
        }
    }

    @Generated
    public static <Request extends TbQueueMsg, Response extends TbQueueMsg> DefaultTbQueueResponseTemplateBuilder<Request, Response> builder() {
        return new DefaultTbQueueResponseTemplateBuilder();
    }

    @Generated
    public static class DefaultTbQueueResponseTemplateBuilder<Request extends TbQueueMsg, Response extends TbQueueMsg> {
        @Generated
        private TbQueueConsumer<Request> requestTemplate;
        @Generated
        private TbQueueProducer<Response> responseTemplate;
        @Generated
        private TbQueueHandler<Request, Response> handler;
        @Generated
        private long pollInterval;
        @Generated
        private long requestTimeout;
        @Generated
        private int maxPendingRequests;
        @Generated
        private ExecutorService executor;
        @Generated
        private MessagesStats stats;

        @Generated
        DefaultTbQueueResponseTemplateBuilder() {
        }

        @Generated
        public DefaultTbQueueResponseTemplateBuilder<Request, Response> requestTemplate(TbQueueConsumer<Request> requestTemplate) {
            this.requestTemplate = requestTemplate;
            return this;
        }

        @Generated
        public DefaultTbQueueResponseTemplateBuilder<Request, Response> responseTemplate(TbQueueProducer<Response> responseTemplate) {
            this.responseTemplate = responseTemplate;
            return this;
        }

        @Generated
        public DefaultTbQueueResponseTemplateBuilder<Request, Response> handler(TbQueueHandler<Request, Response> handler) {
            this.handler = handler;
            return this;
        }

        @Generated
        public DefaultTbQueueResponseTemplateBuilder<Request, Response> pollInterval(long pollInterval) {
            this.pollInterval = pollInterval;
            return this;
        }

        @Generated
        public DefaultTbQueueResponseTemplateBuilder<Request, Response> requestTimeout(long requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        @Generated
        public DefaultTbQueueResponseTemplateBuilder<Request, Response> maxPendingRequests(int maxPendingRequests) {
            this.maxPendingRequests = maxPendingRequests;
            return this;
        }

        @Generated
        public DefaultTbQueueResponseTemplateBuilder<Request, Response> executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        @Generated
        public DefaultTbQueueResponseTemplateBuilder<Request, Response> stats(MessagesStats stats) {
            this.stats = stats;
            return this;
        }

        @Generated
        public DefaultTbQueueResponseTemplate<Request, Response> build() {
            return new DefaultTbQueueResponseTemplate<Request, Response>(this.requestTemplate, this.responseTemplate, this.handler, this.pollInterval, this.requestTimeout, this.maxPendingRequests, this.executor, this.stats);
        }

        @Generated
        public String toString() {
            return "DefaultTbQueueResponseTemplate.DefaultTbQueueResponseTemplateBuilder(requestTemplate=" + String.valueOf(this.requestTemplate) + ", responseTemplate=" + String.valueOf(this.responseTemplate) + ", handler=" + String.valueOf(this.handler) + ", pollInterval=" + this.pollInterval + ", requestTimeout=" + this.requestTimeout + ", maxPendingRequests=" + this.maxPendingRequests + ", executor=" + String.valueOf(this.executor) + ", stats=" + String.valueOf(this.stats) + ")";
        }
    }
}

