/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.common;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.common.AbstractTbQueueConsumerTemplate;

public abstract class AbstractParallelTbQueueConsumerTemplate<R, T extends TbQueueMsg>
extends AbstractTbQueueConsumerTemplate<R, T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractParallelTbQueueConsumerTemplate.class);
    protected ListeningExecutorService consumerExecutor;

    public AbstractParallelTbQueueConsumerTemplate(String topic) {
        super(topic);
    }

    protected void initNewExecutor(int threadPoolSize) {
        if (this.consumerExecutor != null) {
            this.consumerExecutor.shutdown();
            try {
                this.consumerExecutor.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                log.trace("Interrupted while waiting for consumer executor to stop");
            }
        }
        this.consumerExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(threadPoolSize, (ThreadFactory)ThingsBoardThreadFactory.forName((String)this.getClass().getSimpleName())));
    }

    protected void shutdownExecutor() {
        if (this.consumerExecutor != null) {
            this.consumerExecutor.shutdownNow();
        }
    }
}

