/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.kafka.TbKafkaAdmin;
import org.thingsboard.server.queue.kafka.TbKafkaSettings;
import org.thingsboard.server.queue.kafka.TbKafkaTopicConfigs;

@Configuration
public class RuleEngineTbQueueAdminFactory {
    @Autowired(required=false)
    private TbKafkaTopicConfigs kafkaTopicConfigs;
    @Autowired(required=false)
    private TbKafkaSettings kafkaSettings;

    @ConditionalOnExpression(value="'${queue.type:null}'=='kafka'")
    @Bean
    public TbQueueAdmin createKafkaAdmin() {
        return new TbKafkaAdmin(this.kafkaSettings, this.kafkaTopicConfigs.getRuleEngineConfigs());
    }

    @ConditionalOnExpression(value="'${queue.type:null}'=='in-memory'")
    @Bean
    public TbQueueAdmin createInMemoryAdmin() {
        return new TbQueueAdmin(){

            public void createTopicIfNotExists(String topic, String properties, boolean force) {
            }

            public void deleteTopic(String topic) {
            }

            public void destroy() {
            }
        };
    }
}

