/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.usagestats;

import java.beans.ConstructorProperties;
import java.util.EnumMap;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.exception.TenantNotFoundException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.queue.scheduler.SchedulerComponent;

@Component
public class DefaultTbApiUsageReportClient
implements TbApiUsageReportClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultTbApiUsageReportClient.class);
    @Value(value="${usage.stats.report.enabled:true}")
    private boolean enabled;
    @Value(value="${usage.stats.report.enabled_per_customer:false}")
    private boolean enabledPerCustomer;
    @Value(value="${usage.stats.report.interval:10}")
    private int interval;
    private final EnumMap<ApiUsageRecordKey, ConcurrentMap<ReportLevel, AtomicLong>> stats = new EnumMap(ApiUsageRecordKey.class);
    private final PartitionService partitionService;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final SchedulerComponent scheduler;
    private final TbQueueProducerProvider producerProvider;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> msgProducer;

    @PostConstruct
    private void init() {
        if (this.enabled) {
            this.msgProducer = this.producerProvider.getTbUsageStatsMsgProducer();
            for (ApiUsageRecordKey key : ApiUsageRecordKey.values()) {
                this.stats.put(key, new ConcurrentHashMap());
            }
            this.scheduler.scheduleWithFixedDelay(() -> {
                try {
                    this.reportStats();
                }
                catch (Exception e) {
                    log.warn("Failed to report statistics: ", (Throwable)e);
                }
            }, new Random().nextInt(this.interval), this.interval, TimeUnit.SECONDS);
        }
    }

    private void reportStats() {
        ConcurrentHashMap<ParentEntity, TransportProtos.ToUsageStatsServiceMsg.Builder> report = new ConcurrentHashMap<ParentEntity, TransportProtos.ToUsageStatsServiceMsg.Builder>();
        for (ApiUsageRecordKey key : ApiUsageRecordKey.values()) {
            ConcurrentMap<ReportLevel, AtomicLong> statsForKey = this.stats.get(key);
            statsForKey.forEach((reportLevel, statsValue) -> {
                long value = statsValue.get();
                if (value == 0L && key.isCounter()) {
                    return;
                }
                TransportProtos.ToUsageStatsServiceMsg.Builder statsMsg = report.computeIfAbsent(reportLevel.getParentEntity(), parent -> {
                    TransportProtos.ToUsageStatsServiceMsg.Builder newStatsMsg = TransportProtos.ToUsageStatsServiceMsg.newBuilder();
                    TenantId tenantId = parent.getTenantId();
                    newStatsMsg.setTenantIdMSB(tenantId.getId().getMostSignificantBits());
                    newStatsMsg.setTenantIdLSB(tenantId.getId().getLeastSignificantBits());
                    CustomerId customerId = parent.getCustomerId();
                    if (customerId != null) {
                        newStatsMsg.setCustomerIdMSB(customerId.getId().getMostSignificantBits());
                        newStatsMsg.setCustomerIdLSB(customerId.getId().getLeastSignificantBits());
                    }
                    newStatsMsg.setServiceId(this.serviceInfoProvider.getServiceId());
                    return newStatsMsg;
                });
                TransportProtos.UsageStatsKVProto.Builder statsItem = TransportProtos.UsageStatsKVProto.newBuilder().setKey(key.name()).setValue(value);
                statsMsg.addValues(statsItem.build());
            });
            statsForKey.clear();
        }
        report.forEach((parent, statsMsg) -> {
            try {
                TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, parent.getTenantId(), parent.getId()).newByTopic(this.msgProducer.getDefaultTopic());
                this.msgProducer.send(tpi, new TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>(UUID.randomUUID(), statsMsg.build()), null);
            }
            catch (TenantNotFoundException e) {
                log.debug("Couldn't report usage stats for non-existing tenant: {}", (Object)e.getTenantId());
            }
            catch (Exception e) {
                log.warn("Failed to report usage stats for tenant {}", (Object)parent.getTenantId(), (Object)e);
            }
        });
        if (!report.isEmpty()) {
            log.debug("Reporting API usage statistics for {} tenants and customers", (Object)report.size());
        }
    }

    public void report(TenantId tenantId, CustomerId customerId, ApiUsageRecordKey key, long value) {
        if (!this.enabled) {
            return;
        }
        ReportLevel[] reportLevels = new ReportLevel[3];
        reportLevels[0] = ReportLevel.of(tenantId);
        if (key.isCounter()) {
            reportLevels[1] = ReportLevel.of(TenantId.SYS_TENANT_ID);
        }
        if (this.enabledPerCustomer && customerId != null && !customerId.isNullUid()) {
            reportLevels[2] = ReportLevel.of(tenantId, customerId);
        }
        this.report(key, value, reportLevels);
    }

    public void report(TenantId tenantId, CustomerId customerId, ApiUsageRecordKey key) {
        this.report(tenantId, customerId, key, 1L);
    }

    private void report(ApiUsageRecordKey key, long value, ReportLevel ... levels) {
        ConcurrentMap<ReportLevel, AtomicLong> statsForKey = this.stats.get(key);
        for (ReportLevel level : levels) {
            if (level == null) continue;
            AtomicLong n = statsForKey.computeIfAbsent(level, k -> new AtomicLong());
            if (key.isCounter()) {
                n.addAndGet(value);
                continue;
            }
            n.set(value);
        }
    }

    @ConstructorProperties(value={"partitionService", "serviceInfoProvider", "scheduler", "producerProvider"})
    public DefaultTbApiUsageReportClient(PartitionService partitionService, TbServiceInfoProvider serviceInfoProvider, SchedulerComponent scheduler, TbQueueProducerProvider producerProvider) {
        this.partitionService = partitionService;
        this.serviceInfoProvider = serviceInfoProvider;
        this.scheduler = scheduler;
        this.producerProvider = producerProvider;
    }

    private static class ParentEntity {
        private final TenantId tenantId;
        private final CustomerId customerId;

        public EntityId getId() {
            return this.customerId != null ? this.customerId : this.tenantId;
        }

        @ConstructorProperties(value={"tenantId", "customerId"})
        public ParentEntity(TenantId tenantId, CustomerId customerId) {
            this.tenantId = tenantId;
            this.customerId = customerId;
        }

        public TenantId getTenantId() {
            return this.tenantId;
        }

        public CustomerId getCustomerId() {
            return this.customerId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParentEntity)) {
                return false;
            }
            ParentEntity other = (ParentEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TenantId this$tenantId = this.getTenantId();
            TenantId other$tenantId = other.getTenantId();
            if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
                return false;
            }
            CustomerId this$customerId = this.getCustomerId();
            CustomerId other$customerId = other.getCustomerId();
            return !(this$customerId == null ? other$customerId != null : !this$customerId.equals(other$customerId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ParentEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TenantId $tenantId = this.getTenantId();
            result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
            CustomerId $customerId = this.getCustomerId();
            result = result * 59 + ($customerId == null ? 43 : $customerId.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultTbApiUsageReportClient.ParentEntity(tenantId=" + this.getTenantId() + ", customerId=" + this.getCustomerId() + ")";
        }
    }

    private static class ReportLevel {
        private final TenantId tenantId;
        private final CustomerId customerId;

        public static ReportLevel of(TenantId tenantId) {
            return new ReportLevel(tenantId, null);
        }

        public static ReportLevel of(TenantId tenantId, CustomerId customerId) {
            return new ReportLevel(tenantId, customerId);
        }

        public ParentEntity getParentEntity() {
            return new ParentEntity(this.tenantId, this.customerId);
        }

        @ConstructorProperties(value={"tenantId", "customerId"})
        public ReportLevel(TenantId tenantId, CustomerId customerId) {
            this.tenantId = tenantId;
            this.customerId = customerId;
        }

        public TenantId getTenantId() {
            return this.tenantId;
        }

        public CustomerId getCustomerId() {
            return this.customerId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportLevel)) {
                return false;
            }
            ReportLevel other = (ReportLevel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TenantId this$tenantId = this.getTenantId();
            TenantId other$tenantId = other.getTenantId();
            if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
                return false;
            }
            CustomerId this$customerId = this.getCustomerId();
            CustomerId other$customerId = other.getCustomerId();
            return !(this$customerId == null ? other$customerId != null : !this$customerId.equals(other$customerId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReportLevel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TenantId $tenantId = this.getTenantId();
            result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
            CustomerId $customerId = this.getCustomerId();
            result = result * 59 + ($customerId == null ? 43 : $customerId.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultTbApiUsageReportClient.ReportLevel(tenantId=" + this.getTenantId() + ", customerId=" + this.getCustomerId() + ")";
        }
    }
}

