/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.sqs;

import com.amazonaws.services.sqs.model.QueueAttributeName;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.StringUtils;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='aws-sqs'")
public class TbAwsSqsQueueAttributes {
    @Value(value="${queue.aws-sqs.queue-properties.core:}")
    private String coreProperties;
    @Value(value="${queue.aws-sqs.queue-properties.rule-engine:}")
    private String ruleEngineProperties;
    @Value(value="${queue.aws-sqs.queue-properties.transport-api:}")
    private String transportApiProperties;
    @Value(value="${queue.aws-sqs.queue-properties.notifications:}")
    private String notificationsProperties;
    @Value(value="${queue.aws-sqs.queue-properties.js-executor:}")
    private String jsExecutorProperties;
    @Value(value="${queue.aws-sqs.queue-properties.ota-updates:}")
    private String otaProperties;
    @Value(value="${queue.aws-sqs.queue-properties.version-control:}")
    private String vcProperties;
    private Map<String, String> coreAttributes;
    private Map<String, String> ruleEngineAttributes;
    private Map<String, String> transportApiAttributes;
    private Map<String, String> notificationsAttributes;
    private Map<String, String> jsExecutorAttributes;
    private Map<String, String> otaAttributes;
    private Map<String, String> vcAttributes;
    private final Map<String, String> defaultAttributes = new HashMap<String, String>();

    @PostConstruct
    private void init() {
        this.defaultAttributes.put(QueueAttributeName.FifoQueue.toString(), "true");
        this.coreAttributes = this.getConfigs(this.coreProperties);
        this.ruleEngineAttributes = this.getConfigs(this.ruleEngineProperties);
        this.transportApiAttributes = this.getConfigs(this.transportApiProperties);
        this.notificationsAttributes = this.getConfigs(this.notificationsProperties);
        this.jsExecutorAttributes = this.getConfigs(this.jsExecutorProperties);
        this.otaAttributes = this.getConfigs(this.otaProperties);
        this.vcAttributes = this.getConfigs(this.vcProperties);
    }

    private Map<String, String> getConfigs(String properties) {
        HashMap<String, String> configs = new HashMap<String, String>(this.defaultAttributes);
        configs.putAll(TbAwsSqsQueueAttributes.toConfigs(properties));
        return configs;
    }

    public static Map<String, String> toConfigs(String properties) {
        HashMap<String, String> configs = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)properties)) {
            for (String property : properties.split(";")) {
                int delimiterPosition = property.indexOf(":");
                String key = property.substring(0, delimiterPosition);
                String value = property.substring(delimiterPosition + 1);
                TbAwsSqsQueueAttributes.validateAttributeName(key);
                configs.put(key, value);
            }
        }
        return configs;
    }

    private static void validateAttributeName(String key) {
        QueueAttributeName.fromValue((String)key);
    }

    public Map<String, String> getCoreAttributes() {
        return this.coreAttributes;
    }

    public Map<String, String> getRuleEngineAttributes() {
        return this.ruleEngineAttributes;
    }

    public Map<String, String> getTransportApiAttributes() {
        return this.transportApiAttributes;
    }

    public Map<String, String> getNotificationsAttributes() {
        return this.notificationsAttributes;
    }

    public Map<String, String> getJsExecutorAttributes() {
        return this.jsExecutorAttributes;
    }

    public Map<String, String> getOtaAttributes() {
        return this.otaAttributes;
    }

    public Map<String, String> getVcAttributes() {
        return this.vcAttributes;
    }
}

