/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.settings;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
public class TbQueueRemoteJsInvokeSettings {
    @Value(value="${queue.prefix:}")
    private String prefix;
    @Value(value="${queue.js.request_topic}")
    private String requestTopic;
    @Value(value="${queue.js.response_topic_prefix}")
    private String responseTopic;
    @Value(value="${queue.js.max_pending_requests}")
    private long maxPendingRequests;
    @Value(value="${queue.js.response_poll_interval}")
    private int responsePollInterval;
    @Value(value="${queue.js.max_requests_timeout}")
    private long maxRequestsTimeout;

    public String getRequestTopic() {
        return this.prefix.isBlank() ? this.requestTopic : this.prefix + "." + this.requestTopic;
    }

    public String getResponseTopic() {
        return this.prefix.isBlank() ? this.responseTopic : this.prefix + "." + this.responseTopic;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public long getMaxPendingRequests() {
        return this.maxPendingRequests;
    }

    public int getResponsePollInterval() {
        return this.responsePollInterval;
    }

    public long getMaxRequestsTimeout() {
        return this.maxRequestsTimeout;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setRequestTopic(String requestTopic) {
        this.requestTopic = requestTopic;
    }

    public void setResponseTopic(String responseTopic) {
        this.responseTopic = responseTopic;
    }

    public void setMaxPendingRequests(long maxPendingRequests) {
        this.maxPendingRequests = maxPendingRequests;
    }

    public void setResponsePollInterval(int responsePollInterval) {
        this.responsePollInterval = responsePollInterval;
    }

    public void setMaxRequestsTimeout(long maxRequestsTimeout) {
        this.maxRequestsTimeout = maxRequestsTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbQueueRemoteJsInvokeSettings)) {
            return false;
        }
        TbQueueRemoteJsInvokeSettings other = (TbQueueRemoteJsInvokeSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxPendingRequests() != other.getMaxPendingRequests()) {
            return false;
        }
        if (this.getResponsePollInterval() != other.getResponsePollInterval()) {
            return false;
        }
        if (this.getMaxRequestsTimeout() != other.getMaxRequestsTimeout()) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$requestTopic = this.getRequestTopic();
        String other$requestTopic = other.getRequestTopic();
        if (this$requestTopic == null ? other$requestTopic != null : !this$requestTopic.equals(other$requestTopic)) {
            return false;
        }
        String this$responseTopic = this.getResponseTopic();
        String other$responseTopic = other.getResponseTopic();
        return !(this$responseTopic == null ? other$responseTopic != null : !this$responseTopic.equals(other$responseTopic));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbQueueRemoteJsInvokeSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxPendingRequests = this.getMaxPendingRequests();
        result = result * 59 + (int)($maxPendingRequests >>> 32 ^ $maxPendingRequests);
        result = result * 59 + this.getResponsePollInterval();
        long $maxRequestsTimeout = this.getMaxRequestsTimeout();
        result = result * 59 + (int)($maxRequestsTimeout >>> 32 ^ $maxRequestsTimeout);
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $requestTopic = this.getRequestTopic();
        result = result * 59 + ($requestTopic == null ? 43 : $requestTopic.hashCode());
        String $responseTopic = this.getResponseTopic();
        result = result * 59 + ($responseTopic == null ? 43 : $responseTopic.hashCode());
        return result;
    }

    public String toString() {
        return "TbQueueRemoteJsInvokeSettings(prefix=" + this.getPrefix() + ", requestTopic=" + this.getRequestTopic() + ", responseTopic=" + this.getResponseTopic() + ", maxPendingRequests=" + this.getMaxPendingRequests() + ", responsePollInterval=" + this.getResponsePollInterval() + ", maxRequestsTimeout=" + this.getMaxRequestsTimeout() + ")";
    }
}

