/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@ConditionalOnExpression(value="'${queue.type:null}'=='rabbitmq'")
@Component
public class TbRabbitMqSettings {
    private static final Logger log = LoggerFactory.getLogger(TbRabbitMqSettings.class);
    @Value(value="${queue.rabbitmq.exchange_name:}")
    private String exchangeName;
    @Value(value="${queue.rabbitmq.host:}")
    private String host;
    @Value(value="${queue.rabbitmq.port:}")
    private int port;
    @Value(value="${queue.rabbitmq.virtual_host:}")
    private String virtualHost;
    @Value(value="${queue.rabbitmq.username:}")
    private String username;
    @Value(value="${queue.rabbitmq.password:}")
    private String password;
    @Value(value="${queue.rabbitmq.automatic_recovery_enabled:}")
    private boolean automaticRecoveryEnabled;
    @Value(value="${queue.rabbitmq.connection_timeout:}")
    private int connectionTimeout;
    @Value(value="${queue.rabbitmq.handshake_timeout:}")
    private int handshakeTimeout;
    private ConnectionFactory connectionFactory;

    @PostConstruct
    private void init() {
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setHost(this.host);
        this.connectionFactory.setPort(this.port);
        this.connectionFactory.setVirtualHost(this.virtualHost);
        this.connectionFactory.setUsername(this.username);
        this.connectionFactory.setPassword(this.password);
        this.connectionFactory.setAutomaticRecoveryEnabled(this.automaticRecoveryEnabled);
        this.connectionFactory.setConnectionTimeout(this.connectionTimeout);
        this.connectionFactory.setHandshakeTimeout(this.handshakeTimeout);
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAutomaticRecoveryEnabled() {
        return this.automaticRecoveryEnabled;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAutomaticRecoveryEnabled(boolean automaticRecoveryEnabled) {
        this.automaticRecoveryEnabled = automaticRecoveryEnabled;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setHandshakeTimeout(int handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbRabbitMqSettings)) {
            return false;
        }
        TbRabbitMqSettings other = (TbRabbitMqSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isAutomaticRecoveryEnabled() != other.isAutomaticRecoveryEnabled()) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getHandshakeTimeout() != other.getHandshakeTimeout()) {
            return false;
        }
        String this$exchangeName = this.getExchangeName();
        String other$exchangeName = other.getExchangeName();
        if (this$exchangeName == null ? other$exchangeName != null : !this$exchangeName.equals(other$exchangeName)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$virtualHost = this.getVirtualHost();
        String other$virtualHost = other.getVirtualHost();
        if (this$virtualHost == null ? other$virtualHost != null : !this$virtualHost.equals(other$virtualHost)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        ConnectionFactory this$connectionFactory = this.getConnectionFactory();
        ConnectionFactory other$connectionFactory = other.getConnectionFactory();
        return !(this$connectionFactory == null ? other$connectionFactory != null : !this$connectionFactory.equals(other$connectionFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbRabbitMqSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isAutomaticRecoveryEnabled() ? 79 : 97);
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + this.getHandshakeTimeout();
        String $exchangeName = this.getExchangeName();
        result = result * 59 + ($exchangeName == null ? 43 : $exchangeName.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $virtualHost = this.getVirtualHost();
        result = result * 59 + ($virtualHost == null ? 43 : $virtualHost.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        ConnectionFactory $connectionFactory = this.getConnectionFactory();
        result = result * 59 + ($connectionFactory == null ? 43 : $connectionFactory.hashCode());
        return result;
    }

    public String toString() {
        return "TbRabbitMqSettings(exchangeName=" + this.getExchangeName() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", virtualHost=" + this.getVirtualHost() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", automaticRecoveryEnabled=" + this.isAutomaticRecoveryEnabled() + ", connectionTimeout=" + this.getConnectionTimeout() + ", handshakeTimeout=" + this.getHandshakeTimeout() + ", connectionFactory=" + this.getConnectionFactory() + ")";
    }
}

