/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.rabbitmq.TbRabbitMqQueueArguments;
import org.thingsboard.server.queue.rabbitmq.TbRabbitMqSettings;

public class TbRabbitMqAdmin
implements TbQueueAdmin {
    private static final Logger log = LoggerFactory.getLogger(TbRabbitMqAdmin.class);
    private final Channel channel;
    private final Connection connection;
    private final Map<String, Object> arguments;

    public TbRabbitMqAdmin(TbRabbitMqSettings rabbitMqSettings, Map<String, Object> arguments) {
        this.arguments = arguments;
        try {
            this.connection = rabbitMqSettings.getConnectionFactory().newConnection();
        }
        catch (IOException | TimeoutException e) {
            log.error("Failed to create connection.", (Throwable)e);
            throw new RuntimeException("Failed to create connection.", e);
        }
        try {
            this.channel = this.connection.createChannel();
        }
        catch (IOException e) {
            log.error("Failed to create chanel.", (Throwable)e);
            throw new RuntimeException("Failed to create chanel.", e);
        }
    }

    public void createTopicIfNotExists(String topic, String properties) {
        Map<String, Object> arguments = this.arguments;
        if (StringUtils.isNotBlank((CharSequence)properties)) {
            arguments = new HashMap<String, Object>(arguments);
            arguments.putAll(TbRabbitMqQueueArguments.getArgs(properties));
        }
        try {
            this.channel.queueDeclare(topic, false, false, false, arguments);
        }
        catch (IOException e) {
            log.error("Failed to bind queue: [{}]", (Object)topic, (Object)e);
        }
    }

    public void deleteTopic(String topic) {
        try {
            this.channel.queueDelete(topic);
        }
        catch (IOException e) {
            log.error("Failed to delete RabbitMq queue [{}].", (Object)topic);
        }
    }

    public void destroy() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException | TimeoutException e) {
                log.error("Failed to close Chanel.", (Throwable)e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                log.error("Failed to close Connection.", (Throwable)e);
            }
        }
    }
}

