/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.pubsub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@ConditionalOnExpression(value="'${queue.type:null}'=='pubsub'")
@Component
public class TbPubSubSettings {
    private static final Logger log = LoggerFactory.getLogger(TbPubSubSettings.class);
    @Value(value="${queue.pubsub.project_id}")
    private String projectId;
    @Value(value="${queue.pubsub.service_account}")
    private String serviceAccount;
    @Value(value="${queue.pubsub.max_msg_size}")
    private int maxMsgSize;
    @Value(value="${queue.pubsub.max_messages}")
    private int maxMessages;
    private CredentialsProvider credentialsProvider;

    @PostConstruct
    private void init() throws IOException {
        ServiceAccountCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)new ByteArrayInputStream(this.serviceAccount.getBytes()));
        this.credentialsProvider = FixedCredentialsProvider.create((Credentials)credentials);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public int getMaxMsgSize() {
        return this.maxMsgSize;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public void setMaxMsgSize(int maxMsgSize) {
        this.maxMsgSize = maxMsgSize;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbPubSubSettings)) {
            return false;
        }
        TbPubSubSettings other = (TbPubSubSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxMsgSize() != other.getMaxMsgSize()) {
            return false;
        }
        if (this.getMaxMessages() != other.getMaxMessages()) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$serviceAccount = this.getServiceAccount();
        String other$serviceAccount = other.getServiceAccount();
        if (this$serviceAccount == null ? other$serviceAccount != null : !this$serviceAccount.equals(other$serviceAccount)) {
            return false;
        }
        CredentialsProvider this$credentialsProvider = this.getCredentialsProvider();
        CredentialsProvider other$credentialsProvider = other.getCredentialsProvider();
        return !(this$credentialsProvider == null ? other$credentialsProvider != null : !this$credentialsProvider.equals(other$credentialsProvider));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbPubSubSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxMsgSize();
        result = result * 59 + this.getMaxMessages();
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $serviceAccount = this.getServiceAccount();
        result = result * 59 + ($serviceAccount == null ? 43 : $serviceAccount.hashCode());
        CredentialsProvider $credentialsProvider = this.getCredentialsProvider();
        result = result * 59 + ($credentialsProvider == null ? 43 : $credentialsProvider.hashCode());
        return result;
    }

    public String toString() {
        return "TbPubSubSettings(projectId=" + this.getProjectId() + ", serviceAccount=" + this.getServiceAccount() + ", maxMsgSize=" + this.getMaxMsgSize() + ", maxMessages=" + this.getMaxMessages() + ", credentialsProvider=" + this.getCredentialsProvider() + ")";
    }
}

