/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.pubsub;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.TopicName;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.DefaultTbQueueMsg;
import org.thingsboard.server.queue.pubsub.TbPubSubSettings;

public class TbPubSubProducerTemplate<T extends TbQueueMsg>
implements TbQueueProducer<T> {
    private static final Logger log = LoggerFactory.getLogger(TbPubSubProducerTemplate.class);
    private final Gson gson = new Gson();
    private final String defaultTopic;
    private final TbQueueAdmin admin;
    private final TbPubSubSettings pubSubSettings;
    private final Map<String, Publisher> publisherMap = new ConcurrentHashMap<String, Publisher>();
    private final ExecutorService pubExecutor = Executors.newCachedThreadPool();

    public TbPubSubProducerTemplate(TbQueueAdmin admin, TbPubSubSettings pubSubSettings, String defaultTopic) {
        this.defaultTopic = defaultTopic;
        this.admin = admin;
        this.pubSubSettings = pubSubSettings;
    }

    public void init() {
    }

    public String getDefaultTopic() {
        return this.defaultTopic;
    }

    public void send(TopicPartitionInfo tpi, T msg, final TbQueueCallback callback) {
        PubsubMessage.Builder pubsubMessageBuilder = PubsubMessage.newBuilder();
        pubsubMessageBuilder.setData(this.getMsg(msg));
        Publisher publisher = this.getOrCreatePublisher(tpi.getFullTopicName());
        ApiFuture future = publisher.publish(pubsubMessageBuilder.build());
        ApiFutures.addCallback((ApiFuture)future, (ApiFutureCallback)new ApiFutureCallback<String>(){

            public void onSuccess(String messageId) {
                if (callback != null) {
                    callback.onSuccess(null);
                }
            }

            public void onFailure(Throwable t) {
                if (callback != null) {
                    callback.onFailure(t);
                }
            }
        }, (Executor)this.pubExecutor);
    }

    public void stop() {
        this.publisherMap.forEach((k, v) -> {
            if (v != null) {
                try {
                    v.shutdown();
                    v.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    log.error("Failed to shutdown PubSub client during destroy()", (Throwable)e);
                }
            }
        });
        if (this.pubExecutor != null) {
            this.pubExecutor.shutdownNow();
        }
    }

    private ByteString getMsg(T msg) {
        String json = this.gson.toJson((Object)new DefaultTbQueueMsg((TbQueueMsg)msg));
        return ByteString.copyFrom((byte[])json.getBytes());
    }

    private Publisher getOrCreatePublisher(String topic) {
        if (this.publisherMap.containsKey(topic)) {
            return this.publisherMap.get(topic);
        }
        try {
            this.admin.createTopicIfNotExists(topic);
            ProjectTopicName topicName = ProjectTopicName.of((String)this.pubSubSettings.getProjectId(), (String)topic);
            Publisher publisher = Publisher.newBuilder((TopicName)topicName).setCredentialsProvider(this.pubSubSettings.getCredentialsProvider()).build();
            this.publisherMap.put(topic, publisher);
            return publisher;
        }
        catch (IOException e) {
            log.error("Failed to create Publisher for the topic [{}].", (Object)topic, (Object)e);
            throw new RuntimeException("Failed to create Publisher for the topic.", e);
        }
    }
}

