/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.provider;

import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.nio.charset.StandardCharsets;
import javax.annotation.PreDestroy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.gen.js.JsInvokeProtos;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.TbQueueRequestTemplate;
import org.thingsboard.server.queue.common.DefaultTbQueueRequestTemplate;
import org.thingsboard.server.queue.common.TbProtoJsQueueMsg;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.provider.TbRuleEngineQueueFactory;
import org.thingsboard.server.queue.pubsub.TbPubSubAdmin;
import org.thingsboard.server.queue.pubsub.TbPubSubConsumerTemplate;
import org.thingsboard.server.queue.pubsub.TbPubSubProducerTemplate;
import org.thingsboard.server.queue.pubsub.TbPubSubSettings;
import org.thingsboard.server.queue.pubsub.TbPubSubSubscriptionSettings;
import org.thingsboard.server.queue.settings.TbQueueCoreSettings;
import org.thingsboard.server.queue.settings.TbQueueRemoteJsInvokeSettings;
import org.thingsboard.server.queue.settings.TbQueueRuleEngineSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportNotificationSettings;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='pubsub' && '${service.type:null}'=='tb-rule-engine'")
public class PubSubTbRuleEngineQueueFactory
implements TbRuleEngineQueueFactory {
    private final TbPubSubSettings pubSubSettings;
    private final TbQueueCoreSettings coreSettings;
    private final TbQueueRuleEngineSettings ruleEngineSettings;
    private final TopicService topicService;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TbQueueRemoteJsInvokeSettings jsInvokeSettings;
    private final TbQueueTransportNotificationSettings transportNotificationSettings;
    private final TbQueueAdmin coreAdmin;
    private final TbQueueAdmin ruleEngineAdmin;
    private final TbQueueAdmin jsExecutorAdmin;
    private final TbQueueAdmin notificationAdmin;

    public PubSubTbRuleEngineQueueFactory(TbPubSubSettings pubSubSettings, TbQueueCoreSettings coreSettings, TbQueueRuleEngineSettings ruleEngineSettings, TopicService topicService, TbServiceInfoProvider serviceInfoProvider, TbQueueRemoteJsInvokeSettings jsInvokeSettings, TbQueueTransportNotificationSettings transportNotificationSettings, TbPubSubSubscriptionSettings pubSubSubscriptionSettings) {
        this.pubSubSettings = pubSubSettings;
        this.coreSettings = coreSettings;
        this.ruleEngineSettings = ruleEngineSettings;
        this.topicService = topicService;
        this.serviceInfoProvider = serviceInfoProvider;
        this.jsInvokeSettings = jsInvokeSettings;
        this.transportNotificationSettings = transportNotificationSettings;
        this.coreAdmin = new TbPubSubAdmin(pubSubSettings, pubSubSubscriptionSettings.getCoreSettings());
        this.ruleEngineAdmin = new TbPubSubAdmin(pubSubSettings, pubSubSubscriptionSettings.getRuleEngineSettings());
        this.jsExecutorAdmin = new TbPubSubAdmin(pubSubSettings, pubSubSubscriptionSettings.getJsExecutorSettings());
        this.notificationAdmin = new TbPubSubAdmin(pubSubSettings, pubSubSubscriptionSettings.getNotificationsSettings());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> createTransportNotificationsMsgProducer() {
        return new TbPubSubProducerTemplate<TbProtoQueueMsg<TransportProtos.ToTransportMsg>>(this.notificationAdmin, this.pubSubSettings, this.topicService.buildTopicName(this.transportNotificationSettings.getNotificationsTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> createRuleEngineMsgProducer() {
        return new TbPubSubProducerTemplate<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>>(this.ruleEngineAdmin, this.pubSubSettings, this.topicService.buildTopicName(this.ruleEngineSettings.getTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>> createRuleEngineNotificationsMsgProducer() {
        return new TbPubSubProducerTemplate<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>>(this.notificationAdmin, this.pubSubSettings, this.topicService.buildTopicName(this.ruleEngineSettings.getTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> createTbCoreMsgProducer() {
        return new TbPubSubProducerTemplate<TbProtoQueueMsg<TransportProtos.ToCoreMsg>>(this.coreAdmin, this.pubSubSettings, this.topicService.buildTopicName(this.coreSettings.getTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>> createTbCoreNotificationsMsgProducer() {
        return new TbPubSubProducerTemplate<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>>(this.notificationAdmin, this.pubSubSettings, this.topicService.buildTopicName(this.coreSettings.getTopic()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> createToRuleEngineMsgConsumer(Queue configuration) {
        return new TbPubSubConsumerTemplate<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>>(this.ruleEngineAdmin, this.pubSubSettings, this.topicService.buildTopicName(configuration.getTopic()), msg -> new TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>(msg.getKey(), TransportProtos.ToRuleEngineMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>> createToRuleEngineNotificationsMsgConsumer() {
        return new TbPubSubConsumerTemplate<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>>(this.notificationAdmin, this.pubSubSettings, this.topicService.getNotificationsTopic(ServiceType.TB_RULE_ENGINE, this.serviceInfoProvider.getServiceId()).getFullTopicName(), msg -> new TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>(msg.getKey(), TransportProtos.ToRuleEngineNotificationMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
    }

    @Override
    @Bean
    public TbQueueRequestTemplate<TbProtoJsQueueMsg<JsInvokeProtos.RemoteJsRequest>, TbProtoQueueMsg<JsInvokeProtos.RemoteJsResponse>> createRemoteJsRequestTemplate() {
        TbPubSubProducerTemplate producer = new TbPubSubProducerTemplate(this.jsExecutorAdmin, this.pubSubSettings, this.jsInvokeSettings.getRequestTopic());
        TbPubSubConsumerTemplate consumer = new TbPubSubConsumerTemplate(this.jsExecutorAdmin, this.pubSubSettings, this.jsInvokeSettings.getResponseTopic() + "." + this.serviceInfoProvider.getServiceId(), msg -> {
            JsInvokeProtos.RemoteJsResponse.Builder builder = JsInvokeProtos.RemoteJsResponse.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(new String(msg.getData(), StandardCharsets.UTF_8), (Message.Builder)builder);
            return new TbProtoQueueMsg<JsInvokeProtos.RemoteJsResponse>(msg.getKey(), builder.build(), msg.getHeaders());
        });
        DefaultTbQueueRequestTemplate.DefaultTbQueueRequestTemplateBuilder builder = DefaultTbQueueRequestTemplate.builder();
        builder.queueAdmin(this.jsExecutorAdmin);
        builder.requestTemplate(producer);
        builder.responseTemplate(consumer);
        builder.maxPendingRequests(this.jsInvokeSettings.getMaxPendingRequests());
        builder.maxRequestTimeout(this.jsInvokeSettings.getMaxRequestsTimeout());
        builder.pollInterval(this.jsInvokeSettings.getResponsePollInterval());
        return builder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> createToUsageStatsServiceMsgProducer() {
        return new TbPubSubProducerTemplate<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>>(this.coreAdmin, this.pubSubSettings, this.topicService.buildTopicName(this.coreSettings.getUsageStatsTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>> createToOtaPackageStateServiceMsgProducer() {
        return new TbPubSubProducerTemplate<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>>(this.coreAdmin, this.pubSubSettings, this.topicService.buildTopicName(this.coreSettings.getOtaPackageTopic()));
    }

    @PreDestroy
    private void destroy() {
        if (this.coreAdmin != null) {
            this.coreAdmin.destroy();
        }
        if (this.ruleEngineAdmin != null) {
            this.ruleEngineAdmin.destroy();
        }
        if (this.jsExecutorAdmin != null) {
            this.jsExecutorAdmin.destroy();
        }
        if (this.notificationAdmin != null) {
            this.notificationAdmin.destroy();
        }
    }
}

