/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.provider;

import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.TbQueueRequestTemplate;
import org.thingsboard.server.queue.common.DefaultTbQueueRequestTemplate;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.kafka.TbKafkaAdmin;
import org.thingsboard.server.queue.kafka.TbKafkaConsumerStatsService;
import org.thingsboard.server.queue.kafka.TbKafkaConsumerTemplate;
import org.thingsboard.server.queue.kafka.TbKafkaProducerTemplate;
import org.thingsboard.server.queue.kafka.TbKafkaSettings;
import org.thingsboard.server.queue.kafka.TbKafkaTopicConfigs;
import org.thingsboard.server.queue.provider.TbTransportQueueFactory;
import org.thingsboard.server.queue.settings.TbQueueCoreSettings;
import org.thingsboard.server.queue.settings.TbQueueRuleEngineSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportApiSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportNotificationSettings;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='kafka' && (('${service.type:null}'=='monolith' && '${transport.api_enabled:true}'=='true') || '${service.type:null}'=='tb-transport')")
public class KafkaTbTransportQueueFactory
implements TbTransportQueueFactory {
    private static final Logger log = LoggerFactory.getLogger(KafkaTbTransportQueueFactory.class);
    private final TbKafkaSettings kafkaSettings;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TbQueueCoreSettings coreSettings;
    private final TbQueueRuleEngineSettings ruleEngineSettings;
    private final TbQueueTransportApiSettings transportApiSettings;
    private final TbQueueTransportNotificationSettings transportNotificationSettings;
    private final TbKafkaConsumerStatsService consumerStatsService;
    private final TopicService topicService;
    private final TbQueueAdmin coreAdmin;
    private final TbQueueAdmin ruleEngineAdmin;
    private final TbQueueAdmin transportApiRequestAdmin;
    private final TbQueueAdmin transportApiResponseAdmin;
    private final TbQueueAdmin notificationAdmin;

    public KafkaTbTransportQueueFactory(TbKafkaSettings kafkaSettings, TbServiceInfoProvider serviceInfoProvider, TbQueueCoreSettings coreSettings, TbQueueRuleEngineSettings ruleEngineSettings, TbQueueTransportApiSettings transportApiSettings, TbQueueTransportNotificationSettings transportNotificationSettings, TbKafkaConsumerStatsService consumerStatsService, TbKafkaTopicConfigs kafkaTopicConfigs, TopicService topicService) {
        this.kafkaSettings = kafkaSettings;
        this.serviceInfoProvider = serviceInfoProvider;
        this.coreSettings = coreSettings;
        this.ruleEngineSettings = ruleEngineSettings;
        this.transportApiSettings = transportApiSettings;
        this.transportNotificationSettings = transportNotificationSettings;
        this.consumerStatsService = consumerStatsService;
        this.topicService = topicService;
        this.coreAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getCoreConfigs());
        this.ruleEngineAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getRuleEngineConfigs());
        this.transportApiRequestAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getTransportApiRequestConfigs());
        this.transportApiResponseAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getTransportApiResponseConfigs());
        this.notificationAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getNotificationsConfigs());
    }

    @Override
    public TbQueueRequestTemplate<TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>, TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>> createTransportApiRequestTemplate() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("transport-api-request-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.topicService.buildTopicName(this.transportApiSettings.getRequestsTopic()));
        requestBuilder.admin(this.transportApiRequestAdmin);
        TbKafkaConsumerTemplate.TbKafkaConsumerTemplateBuilder<TbProtoQueueMsg> responseBuilder = TbKafkaConsumerTemplate.builder();
        responseBuilder.settings(this.kafkaSettings);
        responseBuilder.topic(this.topicService.buildTopicName(this.transportApiSettings.getResponsesTopic() + "." + this.serviceInfoProvider.getServiceId()));
        responseBuilder.clientId("transport-api-response-" + this.serviceInfoProvider.getServiceId());
        responseBuilder.groupId(this.topicService.buildTopicName("transport-node-" + this.serviceInfoProvider.getServiceId()));
        responseBuilder.decoder(msg -> new TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>(msg.getKey(), TransportProtos.TransportApiResponseMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
        responseBuilder.admin(this.transportApiResponseAdmin);
        responseBuilder.statsService(this.consumerStatsService);
        DefaultTbQueueRequestTemplate.DefaultTbQueueRequestTemplateBuilder templateBuilder = DefaultTbQueueRequestTemplate.builder();
        templateBuilder.queueAdmin(this.transportApiResponseAdmin);
        templateBuilder.requestTemplate(requestBuilder.build());
        templateBuilder.responseTemplate(responseBuilder.build());
        templateBuilder.maxPendingRequests(this.transportApiSettings.getMaxPendingRequests());
        templateBuilder.maxRequestTimeout(this.transportApiSettings.getMaxRequestsTimeout());
        templateBuilder.pollInterval(this.transportApiSettings.getResponsePollInterval());
        return templateBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> createRuleEngineMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("transport-node-rule-engine-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.topicService.buildTopicName(this.ruleEngineSettings.getTopic()));
        requestBuilder.admin(this.ruleEngineAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> createTbCoreMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("transport-node-core-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.topicService.buildTopicName(this.coreSettings.getTopic()));
        requestBuilder.admin(this.coreAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>> createTbCoreNotificationsMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("transport-node-to-core-notifications-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.topicService.buildTopicName(this.coreSettings.getTopic()));
        requestBuilder.admin(this.notificationAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> createTransportNotificationsConsumer() {
        TbKafkaConsumerTemplate.TbKafkaConsumerTemplateBuilder<TbProtoQueueMsg> responseBuilder = TbKafkaConsumerTemplate.builder();
        responseBuilder.settings(this.kafkaSettings);
        responseBuilder.topic(this.topicService.buildTopicName(this.transportNotificationSettings.getNotificationsTopic() + "." + this.serviceInfoProvider.getServiceId()));
        responseBuilder.clientId("transport-api-notifications-" + this.serviceInfoProvider.getServiceId());
        responseBuilder.groupId(this.topicService.buildTopicName("transport-node-" + this.serviceInfoProvider.getServiceId()));
        responseBuilder.decoder(msg -> new TbProtoQueueMsg<TransportProtos.ToTransportMsg>(msg.getKey(), TransportProtos.ToTransportMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
        responseBuilder.admin(this.notificationAdmin);
        responseBuilder.statsService(this.consumerStatsService);
        return responseBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> createToUsageStatsServiceMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("transport-node-us-producer-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.topicService.buildTopicName(this.coreSettings.getUsageStatsTopic()));
        requestBuilder.admin(this.coreAdmin);
        return requestBuilder.build();
    }

    @PreDestroy
    private void destroy() {
        if (this.coreAdmin != null) {
            this.coreAdmin.destroy();
        }
        if (this.ruleEngineAdmin != null) {
            this.ruleEngineAdmin.destroy();
        }
        if (this.transportApiRequestAdmin != null) {
            this.transportApiRequestAdmin.destroy();
        }
        if (this.transportApiResponseAdmin != null) {
            this.transportApiResponseAdmin.destroy();
        }
        if (this.notificationAdmin != null) {
            this.notificationAdmin.destroy();
        }
    }
}

