/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.provider;

import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.nio.charset.StandardCharsets;
import javax.annotation.PreDestroy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.gen.js.JsInvokeProtos;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.TbQueueRequestTemplate;
import org.thingsboard.server.queue.common.DefaultTbQueueRequestTemplate;
import org.thingsboard.server.queue.common.TbProtoJsQueueMsg;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.kafka.TbKafkaAdmin;
import org.thingsboard.server.queue.kafka.TbKafkaConsumerStatsService;
import org.thingsboard.server.queue.kafka.TbKafkaConsumerTemplate;
import org.thingsboard.server.queue.kafka.TbKafkaProducerTemplate;
import org.thingsboard.server.queue.kafka.TbKafkaSettings;
import org.thingsboard.server.queue.kafka.TbKafkaTopicConfigs;
import org.thingsboard.server.queue.provider.TbCoreQueueFactory;
import org.thingsboard.server.queue.settings.TbQueueCoreSettings;
import org.thingsboard.server.queue.settings.TbQueueRemoteJsInvokeSettings;
import org.thingsboard.server.queue.settings.TbQueueRuleEngineSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportApiSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportNotificationSettings;
import org.thingsboard.server.queue.settings.TbQueueVersionControlSettings;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='kafka' && '${service.type:null}'=='tb-core'")
public class KafkaTbCoreQueueFactory
implements TbCoreQueueFactory {
    private final TopicService topicService;
    private final TbKafkaSettings kafkaSettings;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TbQueueCoreSettings coreSettings;
    private final TbQueueRuleEngineSettings ruleEngineSettings;
    private final TbQueueTransportApiSettings transportApiSettings;
    private final TbQueueRemoteJsInvokeSettings jsInvokeSettings;
    private final TbQueueVersionControlSettings vcSettings;
    private final TbKafkaConsumerStatsService consumerStatsService;
    private final TbQueueTransportNotificationSettings transportNotificationSettings;
    private final TbQueueAdmin coreAdmin;
    private final TbQueueAdmin ruleEngineAdmin;
    private final TbQueueAdmin jsExecutorRequestAdmin;
    private final TbQueueAdmin jsExecutorResponseAdmin;
    private final TbQueueAdmin transportApiRequestAdmin;
    private final TbQueueAdmin transportApiResponseAdmin;
    private final TbQueueAdmin notificationAdmin;
    private final TbQueueAdmin fwUpdatesAdmin;
    private final TbQueueAdmin vcAdmin;

    public KafkaTbCoreQueueFactory(TopicService topicService, TbKafkaSettings kafkaSettings, TbServiceInfoProvider serviceInfoProvider, TbQueueCoreSettings coreSettings, TbQueueRuleEngineSettings ruleEngineSettings, TbQueueTransportApiSettings transportApiSettings, TbQueueRemoteJsInvokeSettings jsInvokeSettings, TbQueueVersionControlSettings vcSettings, TbKafkaConsumerStatsService consumerStatsService, TbQueueTransportNotificationSettings transportNotificationSettings, TbKafkaTopicConfigs kafkaTopicConfigs) {
        this.topicService = topicService;
        this.kafkaSettings = kafkaSettings;
        this.serviceInfoProvider = serviceInfoProvider;
        this.coreSettings = coreSettings;
        this.ruleEngineSettings = ruleEngineSettings;
        this.transportApiSettings = transportApiSettings;
        this.jsInvokeSettings = jsInvokeSettings;
        this.vcSettings = vcSettings;
        this.consumerStatsService = consumerStatsService;
        this.transportNotificationSettings = transportNotificationSettings;
        this.coreAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getCoreConfigs());
        this.ruleEngineAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getRuleEngineConfigs());
        this.jsExecutorRequestAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getJsExecutorRequestConfigs());
        this.jsExecutorResponseAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getJsExecutorResponseConfigs());
        this.transportApiRequestAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getTransportApiRequestConfigs());
        this.transportApiResponseAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getTransportApiResponseConfigs());
        this.notificationAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getNotificationsConfigs());
        this.fwUpdatesAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getFwUpdatesConfigs());
        this.vcAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getVcConfigs());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> createTransportNotificationsMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-core-transport-notifications-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.topicService.buildTopicName(this.transportNotificationSettings.getNotificationsTopic()));
        requestBuilder.admin(this.notificationAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> createRuleEngineMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-core-rule-engine-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.topicService.buildTopicName(this.coreSettings.getTopic()));
        requestBuilder.admin(this.coreAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>> createRuleEngineNotificationsMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-core-rule-engine-notifications-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.topicService.buildTopicName(this.ruleEngineSettings.getTopic()));
        requestBuilder.admin(this.notificationAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> createTbCoreMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-core-to-core-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.topicService.buildTopicName(this.coreSettings.getTopic()));
        requestBuilder.admin(this.coreAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>> createTbCoreNotificationsMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-core-to-core-notifications-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.topicService.buildTopicName(this.coreSettings.getTopic()));
        requestBuilder.admin(this.notificationAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> createToCoreMsgConsumer() {
        TbKafkaConsumerTemplate.TbKafkaConsumerTemplateBuilder<TbProtoQueueMsg> consumerBuilder = TbKafkaConsumerTemplate.builder();
        consumerBuilder.settings(this.kafkaSettings);
        consumerBuilder.topic(this.topicService.buildTopicName(this.coreSettings.getTopic()));
        consumerBuilder.clientId("tb-core-consumer-" + this.serviceInfoProvider.getServiceId());
        consumerBuilder.groupId(this.topicService.buildTopicName("tb-core-node"));
        consumerBuilder.decoder(msg -> new TbProtoQueueMsg<TransportProtos.ToCoreMsg>(msg.getKey(), TransportProtos.ToCoreMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
        consumerBuilder.admin(this.coreAdmin);
        consumerBuilder.statsService(this.consumerStatsService);
        return consumerBuilder.build();
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>> createToCoreNotificationsMsgConsumer() {
        TbKafkaConsumerTemplate.TbKafkaConsumerTemplateBuilder<TbProtoQueueMsg> consumerBuilder = TbKafkaConsumerTemplate.builder();
        consumerBuilder.settings(this.kafkaSettings);
        consumerBuilder.topic(this.topicService.getNotificationsTopic(ServiceType.TB_CORE, this.serviceInfoProvider.getServiceId()).getFullTopicName());
        consumerBuilder.clientId("tb-core-notifications-consumer-" + this.serviceInfoProvider.getServiceId());
        consumerBuilder.groupId(this.topicService.buildTopicName("tb-core-notifications-node-" + this.serviceInfoProvider.getServiceId()));
        consumerBuilder.decoder(msg -> new TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>(msg.getKey(), TransportProtos.ToCoreNotificationMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
        consumerBuilder.admin(this.notificationAdmin);
        consumerBuilder.statsService(this.consumerStatsService);
        return consumerBuilder.build();
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>> createTransportApiRequestConsumer() {
        TbKafkaConsumerTemplate.TbKafkaConsumerTemplateBuilder<TbProtoQueueMsg> consumerBuilder = TbKafkaConsumerTemplate.builder();
        consumerBuilder.settings(this.kafkaSettings);
        consumerBuilder.topic(this.topicService.buildTopicName(this.transportApiSettings.getRequestsTopic()));
        consumerBuilder.clientId("tb-core-transport-api-consumer-" + this.serviceInfoProvider.getServiceId());
        consumerBuilder.groupId(this.topicService.buildTopicName("tb-core-transport-api-consumer"));
        consumerBuilder.decoder(msg -> new TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>(msg.getKey(), TransportProtos.TransportApiRequestMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
        consumerBuilder.admin(this.transportApiRequestAdmin);
        consumerBuilder.statsService(this.consumerStatsService);
        return consumerBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>> createTransportApiResponseProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-core-transport-api-producer-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.topicService.buildTopicName(this.transportApiSettings.getResponsesTopic()));
        requestBuilder.admin(this.transportApiResponseAdmin);
        return requestBuilder.build();
    }

    @Override
    @Bean
    public TbQueueRequestTemplate<TbProtoJsQueueMsg<JsInvokeProtos.RemoteJsRequest>, TbProtoQueueMsg<JsInvokeProtos.RemoteJsResponse>> createRemoteJsRequestTemplate() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("producer-js-invoke-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.jsInvokeSettings.getRequestTopic());
        requestBuilder.admin(this.jsExecutorRequestAdmin);
        TbKafkaConsumerTemplate.TbKafkaConsumerTemplateBuilder<TbProtoQueueMsg> responseBuilder = TbKafkaConsumerTemplate.builder();
        responseBuilder.settings(this.kafkaSettings);
        responseBuilder.topic(this.jsInvokeSettings.getResponseTopic() + "." + this.serviceInfoProvider.getServiceId());
        responseBuilder.clientId("js-" + this.serviceInfoProvider.getServiceId());
        responseBuilder.groupId("rule-engine-node-" + this.serviceInfoProvider.getServiceId());
        responseBuilder.decoder(msg -> {
            JsInvokeProtos.RemoteJsResponse.Builder builder = JsInvokeProtos.RemoteJsResponse.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(new String(msg.getData(), StandardCharsets.UTF_8), (Message.Builder)builder);
            return new TbProtoQueueMsg<JsInvokeProtos.RemoteJsResponse>(msg.getKey(), builder.build(), msg.getHeaders());
        });
        responseBuilder.admin(this.jsExecutorResponseAdmin);
        responseBuilder.statsService(this.consumerStatsService);
        DefaultTbQueueRequestTemplate.DefaultTbQueueRequestTemplateBuilder builder = DefaultTbQueueRequestTemplate.builder();
        builder.queueAdmin(this.jsExecutorResponseAdmin);
        builder.requestTemplate(requestBuilder.build());
        builder.responseTemplate(responseBuilder.build());
        builder.maxPendingRequests(this.jsInvokeSettings.getMaxPendingRequests());
        builder.maxRequestTimeout(this.jsInvokeSettings.getMaxRequestsTimeout());
        builder.pollInterval(this.jsInvokeSettings.getResponsePollInterval());
        return builder.build();
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> createToUsageStatsServiceMsgConsumer() {
        TbKafkaConsumerTemplate.TbKafkaConsumerTemplateBuilder<TbProtoQueueMsg> consumerBuilder = TbKafkaConsumerTemplate.builder();
        consumerBuilder.settings(this.kafkaSettings);
        consumerBuilder.topic(this.topicService.buildTopicName(this.coreSettings.getUsageStatsTopic()));
        consumerBuilder.clientId("tb-core-us-consumer-" + this.serviceInfoProvider.getServiceId());
        consumerBuilder.groupId(this.topicService.buildTopicName("tb-core-us-consumer"));
        consumerBuilder.decoder(msg -> new TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>(msg.getKey(), TransportProtos.ToUsageStatsServiceMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
        consumerBuilder.admin(this.coreAdmin);
        consumerBuilder.statsService(this.consumerStatsService);
        return consumerBuilder.build();
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>> createToOtaPackageStateServiceMsgConsumer() {
        TbKafkaConsumerTemplate.TbKafkaConsumerTemplateBuilder<TbProtoQueueMsg> consumerBuilder = TbKafkaConsumerTemplate.builder();
        consumerBuilder.settings(this.kafkaSettings);
        consumerBuilder.topic(this.topicService.buildTopicName(this.coreSettings.getOtaPackageTopic()));
        consumerBuilder.clientId("tb-core-ota-consumer-" + this.serviceInfoProvider.getServiceId());
        consumerBuilder.groupId(this.topicService.buildTopicName("tb-core-ota-consumer"));
        consumerBuilder.decoder(msg -> new TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>(msg.getKey(), TransportProtos.ToOtaPackageStateServiceMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
        consumerBuilder.admin(this.fwUpdatesAdmin);
        consumerBuilder.statsService(this.consumerStatsService);
        return consumerBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>> createToOtaPackageStateServiceMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-core-ota-producer-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.topicService.buildTopicName(this.coreSettings.getOtaPackageTopic()));
        requestBuilder.admin(this.fwUpdatesAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> createToUsageStatsServiceMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-core-us-producer-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.topicService.buildTopicName(this.coreSettings.getUsageStatsTopic()));
        requestBuilder.admin(this.coreAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToVersionControlServiceMsg>> createVersionControlMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-core-vc-producer-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.topicService.buildTopicName(this.vcSettings.getTopic()));
        requestBuilder.admin(this.vcAdmin);
        return requestBuilder.build();
    }

    @PreDestroy
    private void destroy() {
        if (this.coreAdmin != null) {
            this.coreAdmin.destroy();
        }
        if (this.ruleEngineAdmin != null) {
            this.ruleEngineAdmin.destroy();
        }
        if (this.jsExecutorRequestAdmin != null) {
            this.jsExecutorRequestAdmin.destroy();
        }
        if (this.jsExecutorResponseAdmin != null) {
            this.jsExecutorResponseAdmin.destroy();
        }
        if (this.transportApiRequestAdmin != null) {
            this.transportApiRequestAdmin.destroy();
        }
        if (this.transportApiResponseAdmin != null) {
            this.transportApiResponseAdmin.destroy();
        }
        if (this.notificationAdmin != null) {
            this.notificationAdmin.destroy();
        }
        if (this.fwUpdatesAdmin != null) {
            this.fwUpdatesAdmin.destroy();
        }
        if (this.vcAdmin != null) {
            this.vcAdmin.destroy();
        }
    }
}

