/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.provider;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.TbQueueRequestTemplate;
import org.thingsboard.server.queue.common.DefaultTbQueueRequestTemplate;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.memory.InMemoryStorage;
import org.thingsboard.server.queue.memory.InMemoryTbQueueConsumer;
import org.thingsboard.server.queue.memory.InMemoryTbQueueProducer;
import org.thingsboard.server.queue.provider.TbTransportQueueFactory;
import org.thingsboard.server.queue.settings.TbQueueCoreSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportApiSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportNotificationSettings;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='in-memory' && (('${service.type:null}'=='monolith' && '${transport.api_enabled:true}'=='true') || '${service.type:null}'=='tb-transport')")
public class InMemoryTbTransportQueueFactory
implements TbTransportQueueFactory {
    private static final Logger log = LoggerFactory.getLogger(InMemoryTbTransportQueueFactory.class);
    private final TbQueueTransportApiSettings transportApiSettings;
    private final TbQueueTransportNotificationSettings transportNotificationSettings;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TbQueueCoreSettings coreSettings;
    private final InMemoryStorage storage;
    private final TopicService topicService;

    public InMemoryTbTransportQueueFactory(TbQueueTransportApiSettings transportApiSettings, TbQueueTransportNotificationSettings transportNotificationSettings, TbServiceInfoProvider serviceInfoProvider, TbQueueCoreSettings coreSettings, InMemoryStorage storage, TopicService topicService) {
        this.transportApiSettings = transportApiSettings;
        this.transportNotificationSettings = transportNotificationSettings;
        this.serviceInfoProvider = serviceInfoProvider;
        this.coreSettings = coreSettings;
        this.storage = storage;
        this.topicService = topicService;
    }

    @Override
    public TbQueueRequestTemplate<TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>, TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>> createTransportApiRequestTemplate() {
        InMemoryTbQueueProducer producerTemplate = new InMemoryTbQueueProducer(this.storage, this.topicService.buildTopicName(this.transportApiSettings.getRequestsTopic()));
        InMemoryTbQueueConsumer consumerTemplate = new InMemoryTbQueueConsumer(this.storage, this.topicService.buildTopicName(this.transportApiSettings.getResponsesTopic() + "." + this.serviceInfoProvider.getServiceId()));
        DefaultTbQueueRequestTemplate.DefaultTbQueueRequestTemplateBuilder templateBuilder = DefaultTbQueueRequestTemplate.builder();
        templateBuilder.queueAdmin(new TbQueueAdmin(){

            public void createTopicIfNotExists(String topic, String properties) {
            }

            public void destroy() {
            }

            public void deleteTopic(String topic) {
            }
        });
        templateBuilder.requestTemplate(producerTemplate);
        templateBuilder.responseTemplate(consumerTemplate);
        templateBuilder.maxPendingRequests(this.transportApiSettings.getMaxPendingRequests());
        templateBuilder.maxRequestTimeout(this.transportApiSettings.getMaxRequestsTimeout());
        templateBuilder.pollInterval(this.transportApiSettings.getResponsePollInterval());
        return templateBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> createRuleEngineMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>>(this.storage, this.topicService.buildTopicName(this.transportApiSettings.getRequestsTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> createTbCoreMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>>(this.storage, this.topicService.buildTopicName(this.coreSettings.getTopic()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>> createTbCoreNotificationsMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>>(this.storage, this.topicService.buildTopicName(this.coreSettings.getTopic()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> createTransportNotificationsConsumer() {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>>(this.storage, this.topicService.buildTopicName(this.transportNotificationSettings.getNotificationsTopic() + "." + this.serviceInfoProvider.getServiceId()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> createToUsageStatsServiceMsgProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>>(this.storage, this.topicService.buildTopicName(this.coreSettings.getUsageStatsTopic()));
    }
}

