/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.kafka;

import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.thingsboard.server.queue.util.PropertyUtils;

@Component
@ConditionalOnProperty(prefix="queue", value={"type"}, havingValue="kafka")
public class TbKafkaTopicConfigs {
    public static final String NUM_PARTITIONS_SETTING = "partitions";
    @Value(value="${queue.kafka.topic-properties.core:}")
    private String coreProperties;
    @Value(value="${queue.kafka.topic-properties.rule-engine:}")
    private String ruleEngineProperties;
    @Value(value="${queue.kafka.topic-properties.transport-api:}")
    private String transportApiProperties;
    @Value(value="${queue.kafka.topic-properties.notifications:}")
    private String notificationsProperties;
    @Value(value="${queue.kafka.topic-properties.js-executor:}")
    private String jsExecutorProperties;
    @Value(value="${queue.kafka.topic-properties.ota-updates:}")
    private String fwUpdatesProperties;
    @Value(value="${queue.kafka.topic-properties.version-control:}")
    private String vcProperties;
    private Map<String, String> coreConfigs;
    private Map<String, String> ruleEngineConfigs;
    private Map<String, String> transportApiRequestConfigs;
    private Map<String, String> transportApiResponseConfigs;
    private Map<String, String> notificationsConfigs;
    private Map<String, String> jsExecutorRequestConfigs;
    private Map<String, String> jsExecutorResponseConfigs;
    private Map<String, String> fwUpdatesConfigs;
    private Map<String, String> vcConfigs;

    @PostConstruct
    private void init() {
        this.coreConfigs = PropertyUtils.getProps(this.coreProperties);
        this.ruleEngineConfigs = PropertyUtils.getProps(this.ruleEngineProperties);
        this.transportApiRequestConfigs = PropertyUtils.getProps(this.transportApiProperties);
        this.transportApiResponseConfigs = PropertyUtils.getProps(this.transportApiProperties);
        this.transportApiResponseConfigs.put(NUM_PARTITIONS_SETTING, "1");
        this.notificationsConfigs = PropertyUtils.getProps(this.notificationsProperties);
        this.jsExecutorRequestConfigs = PropertyUtils.getProps(this.jsExecutorProperties);
        this.jsExecutorResponseConfigs = PropertyUtils.getProps(this.jsExecutorProperties);
        this.jsExecutorResponseConfigs.put(NUM_PARTITIONS_SETTING, "1");
        this.fwUpdatesConfigs = PropertyUtils.getProps(this.fwUpdatesProperties);
        this.vcConfigs = PropertyUtils.getProps(this.vcProperties);
    }

    public Map<String, String> getCoreConfigs() {
        return this.coreConfigs;
    }

    public Map<String, String> getRuleEngineConfigs() {
        return this.ruleEngineConfigs;
    }

    public Map<String, String> getTransportApiRequestConfigs() {
        return this.transportApiRequestConfigs;
    }

    public Map<String, String> getTransportApiResponseConfigs() {
        return this.transportApiResponseConfigs;
    }

    public Map<String, String> getNotificationsConfigs() {
        return this.notificationsConfigs;
    }

    public Map<String, String> getJsExecutorRequestConfigs() {
        return this.jsExecutorRequestConfigs;
    }

    public Map<String, String> getJsExecutorResponseConfigs() {
        return this.jsExecutorResponseConfigs;
    }

    public Map<String, String> getFwUpdatesConfigs() {
        return this.fwUpdatesConfigs;
    }

    public Map<String, String> getVcConfigs() {
        return this.vcConfigs;
    }
}

