/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.kafka;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.common.AbstractTbQueueConsumerTemplate;
import org.thingsboard.server.queue.kafka.KafkaTbQueueMsg;
import org.thingsboard.server.queue.kafka.TbKafkaConsumerStatsService;
import org.thingsboard.server.queue.kafka.TbKafkaDecoder;
import org.thingsboard.server.queue.kafka.TbKafkaSettings;

public class TbKafkaConsumerTemplate<T extends TbQueueMsg>
extends AbstractTbQueueConsumerTemplate<ConsumerRecord<String, byte[]>, T> {
    private static final Logger log = LoggerFactory.getLogger(TbKafkaConsumerTemplate.class);
    private final TbQueueAdmin admin;
    private final KafkaConsumer<String, byte[]> consumer;
    private final TbKafkaDecoder<T> decoder;
    private final TbKafkaConsumerStatsService statsService;
    private final String groupId;

    private TbKafkaConsumerTemplate(TbKafkaSettings settings, TbKafkaDecoder<T> decoder, String clientId, String groupId, String topic, TbQueueAdmin admin, TbKafkaConsumerStatsService statsService) {
        super(topic);
        Properties props = settings.toConsumerProps(topic);
        props.put("client.id", clientId);
        if (groupId != null) {
            props.put("group.id", groupId);
        }
        this.statsService = statsService;
        this.groupId = groupId;
        if (statsService != null) {
            statsService.registerClientGroup(groupId);
        }
        this.admin = admin;
        this.consumer = new KafkaConsumer(props);
        this.decoder = decoder;
    }

    @Override
    protected void doSubscribe(List<String> topicNames) {
        if (!topicNames.isEmpty()) {
            topicNames.forEach(arg_0 -> ((TbQueueAdmin)this.admin).createTopicIfNotExists(arg_0));
            this.consumer.subscribe(topicNames);
        } else {
            log.info("unsubscribe due to empty topic list");
            this.consumer.unsubscribe();
        }
    }

    @Override
    protected List<ConsumerRecord<String, byte[]>> doPoll(long durationInMillis) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        log.trace("poll topic {} maxDuration {}", (Object)this.getTopic(), (Object)durationInMillis);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(durationInMillis));
        stopWatch.stop();
        log.trace("poll topic {} took {}ms", (Object)this.getTopic(), (Object)stopWatch.getTotalTimeMillis());
        if (records.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ConsumerRecord<String, byte[]>> recordList = new ArrayList<ConsumerRecord<String, byte[]>>(256);
        records.forEach(recordList::add);
        return recordList;
    }

    @Override
    public T decode(ConsumerRecord<String, byte[]> record) throws IOException {
        return (T)((TbQueueMsg)this.decoder.decode(new KafkaTbQueueMsg(record)));
    }

    @Override
    protected void doCommit() {
        this.consumer.commitSync();
    }

    @Override
    protected void doUnsubscribe() {
        if (this.consumer != null) {
            this.consumer.unsubscribe();
            this.consumer.close();
        }
        if (this.statsService != null) {
            this.statsService.unregisterClientGroup(this.groupId);
        }
    }

    @Override
    public boolean isLongPollingSupported() {
        return true;
    }

    public static <T extends TbQueueMsg> TbKafkaConsumerTemplateBuilder<T> builder() {
        return new TbKafkaConsumerTemplateBuilder();
    }

    public static class TbKafkaConsumerTemplateBuilder<T extends TbQueueMsg> {
        private TbKafkaSettings settings;
        private TbKafkaDecoder<T> decoder;
        private String clientId;
        private String groupId;
        private String topic;
        private TbQueueAdmin admin;
        private TbKafkaConsumerStatsService statsService;

        TbKafkaConsumerTemplateBuilder() {
        }

        public TbKafkaConsumerTemplateBuilder<T> settings(TbKafkaSettings settings) {
            this.settings = settings;
            return this;
        }

        public TbKafkaConsumerTemplateBuilder<T> decoder(TbKafkaDecoder<T> decoder) {
            this.decoder = decoder;
            return this;
        }

        public TbKafkaConsumerTemplateBuilder<T> clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public TbKafkaConsumerTemplateBuilder<T> groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public TbKafkaConsumerTemplateBuilder<T> topic(String topic) {
            this.topic = topic;
            return this;
        }

        public TbKafkaConsumerTemplateBuilder<T> admin(TbQueueAdmin admin) {
            this.admin = admin;
            return this;
        }

        public TbKafkaConsumerTemplateBuilder<T> statsService(TbKafkaConsumerStatsService statsService) {
            this.statsService = statsService;
            return this;
        }

        public TbKafkaConsumerTemplate<T> build() {
            return new TbKafkaConsumerTemplate<T>(this.settings, this.decoder, this.clientId, this.groupId, this.topic, this.admin, this.statsService);
        }

        public String toString() {
            return "TbKafkaConsumerTemplate.TbKafkaConsumerTemplateBuilder(settings=" + this.settings + ", decoder=" + this.decoder + ", clientId=" + this.clientId + ", groupId=" + this.groupId + ", topic=" + this.topic + ", admin=" + this.admin + ", statsService=" + this.statsService + ")";
        }
    }
}

