/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.kafka;

import java.beans.ConstructorProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="queue", value={"type"}, havingValue="kafka")
public class TbKafkaConsumerStatisticConfig {
    @Value(value="${queue.kafka.consumer-stats.enabled:true}")
    private Boolean enabled;
    @Value(value="${queue.kafka.consumer-stats.print-interval-ms:60000}")
    private Long printIntervalMs;
    @Value(value="${queue.kafka.consumer-stats.kafka-response-timeout-ms:1000}")
    private Long kafkaResponseTimeoutMs;

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Long getPrintIntervalMs() {
        return this.printIntervalMs;
    }

    public Long getKafkaResponseTimeoutMs() {
        return this.kafkaResponseTimeoutMs;
    }

    @ConstructorProperties(value={"enabled", "printIntervalMs", "kafkaResponseTimeoutMs"})
    public TbKafkaConsumerStatisticConfig(Boolean enabled, Long printIntervalMs, Long kafkaResponseTimeoutMs) {
        this.enabled = enabled;
        this.printIntervalMs = printIntervalMs;
        this.kafkaResponseTimeoutMs = kafkaResponseTimeoutMs;
    }

    public TbKafkaConsumerStatisticConfig() {
    }
}

