/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.TopicExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.kafka.TbKafkaSettings;
import org.thingsboard.server.queue.util.PropertyUtils;

public class TbKafkaAdmin
implements TbQueueAdmin {
    private static final Logger log = LoggerFactory.getLogger(TbKafkaAdmin.class);
    private final AdminClient client;
    private final Map<String, String> topicConfigs;
    private final Set<String> topics = ConcurrentHashMap.newKeySet();
    private final int numPartitions;
    private final short replicationFactor;

    public TbKafkaAdmin(TbKafkaSettings settings, Map<String, String> topicConfigs) {
        this.client = AdminClient.create((Properties)settings.toAdminProps());
        this.topicConfigs = topicConfigs;
        try {
            this.topics.addAll((Collection)this.client.listTopics().names().get());
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Failed to get all topics.", (Throwable)e);
        }
        String numPartitionsStr = topicConfigs.get("partitions");
        if (numPartitionsStr != null) {
            this.numPartitions = Integer.parseInt(numPartitionsStr);
            topicConfigs.remove("partitions");
        } else {
            this.numPartitions = 1;
        }
        this.replicationFactor = settings.getReplicationFactor();
    }

    public void createTopicIfNotExists(String topic, String properties) {
        if (this.topics.contains(topic)) {
            return;
        }
        try {
            NewTopic newTopic = new NewTopic(topic, this.numPartitions, this.replicationFactor).configs(PropertyUtils.getProps(this.topicConfigs, properties));
            ((KafkaFuture)this.createTopic(newTopic).values().get(topic)).get();
            this.topics.add(topic);
        }
        catch (ExecutionException ee) {
            if (!(ee.getCause() instanceof TopicExistsException)) {
                log.warn("[{}] Failed to create topic", (Object)topic, (Object)ee);
                throw new RuntimeException(ee);
            }
        }
        catch (Exception e) {
            log.warn("[{}] Failed to create topic", (Object)topic, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void deleteTopic(String topic) {
        if (this.topics.contains(topic)) {
            this.client.deleteTopics(Collections.singletonList(topic));
        } else {
            try {
                if (((Set)this.client.listTopics().names().get()).contains(topic)) {
                    this.client.deleteTopics(Collections.singletonList(topic));
                } else {
                    log.warn("Kafka topic [{}] does not exist.", (Object)topic);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Failed to delete kafka topic [{}].", (Object)topic, (Object)e);
            }
        }
    }

    public void destroy() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public CreateTopicsResult createTopic(NewTopic topic) {
        return this.client.createTopics(Collections.singletonList(topic));
    }
}

