/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.discovery;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.queue.discovery.QueueRoutingInfo;

public class QueueKey {
    private final ServiceType type;
    private final String queueName;
    private final TenantId tenantId;

    public QueueKey(ServiceType type, Queue queue) {
        this.type = type;
        this.queueName = queue.getName();
        this.tenantId = queue.getTenantId();
    }

    public QueueKey(ServiceType type, QueueRoutingInfo queueRoutingInfo) {
        this.type = type;
        this.queueName = queueRoutingInfo.getQueueName();
        this.tenantId = queueRoutingInfo.getTenantId();
    }

    public QueueKey(ServiceType type, TenantId tenantId) {
        this.type = type;
        this.queueName = "Main";
        this.tenantId = tenantId != null ? tenantId : TenantId.SYS_TENANT_ID;
    }

    public QueueKey(ServiceType type) {
        this.type = type;
        this.queueName = "Main";
        this.tenantId = TenantId.SYS_TENANT_ID;
    }

    public String toString() {
        return "QK(" + this.queueName + "," + this.type + "," + (Serializable)((Object)(TenantId.SYS_TENANT_ID.equals((Object)this.tenantId) ? "system" : this.tenantId)) + ")";
    }

    public ServiceType getType() {
        return this.type;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueKey)) {
            return false;
        }
        QueueKey other = (QueueKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ServiceType this$type = this.getType();
        ServiceType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$queueName = this.getQueueName();
        String other$queueName = other.getQueueName();
        if (this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueueKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ServiceType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $queueName = this.getQueueName();
        result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        return result;
    }

    @ConstructorProperties(value={"type", "queueName", "tenantId"})
    public QueueKey(ServiceType type, String queueName, TenantId tenantId) {
        this.type = type;
        this.queueName = queueName;
        this.tenantId = tenantId;
    }
}

