/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.SystemUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TbTransportService;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.util.AfterContextReady;

@Component
public class DefaultTbServiceInfoProvider
implements TbServiceInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultTbServiceInfoProvider.class);
    @Value(value="${service.id:#{null}}")
    private String serviceId;
    @Value(value="${service.type:monolith}")
    private String serviceType;
    @Value(value="${service.rule_engine.assigned_tenant_profiles:}")
    private Set<UUID> assignedTenantProfiles;
    @Autowired
    private ApplicationContext applicationContext;
    private List<ServiceType> serviceTypes;
    private TransportProtos.ServiceInfo serviceInfo;

    @PostConstruct
    public void init() {
        if (StringUtils.isEmpty((String)this.serviceId)) {
            try {
                this.serviceId = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.serviceId = StringUtils.randomAlphabetic((int)10);
            }
        }
        log.info("Current Service ID: {}", (Object)this.serviceId);
        this.serviceTypes = this.serviceType.equalsIgnoreCase("monolith") ? Collections.unmodifiableList(Arrays.asList(ServiceType.values())) : Collections.singletonList(ServiceType.of((String)this.serviceType));
        if (!this.serviceTypes.contains(ServiceType.TB_RULE_ENGINE) || this.assignedTenantProfiles == null) {
            this.assignedTenantProfiles = Collections.emptySet();
        }
        this.generateNewServiceInfoWithCurrentSystemInfo();
    }

    @AfterContextReady
    public void setTransports() {
        this.serviceInfo = TransportProtos.ServiceInfo.newBuilder((TransportProtos.ServiceInfo)this.serviceInfo).addAllTransports((Iterable)this.getTransportServices().stream().map(TbTransportService::getName).collect(Collectors.toSet())).build();
    }

    private Collection<TbTransportService> getTransportServices() {
        return this.applicationContext.getBeansOfType(TbTransportService.class).values();
    }

    @Override
    public TransportProtos.ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    @Override
    public boolean isService(ServiceType serviceType) {
        return this.serviceTypes.contains(serviceType);
    }

    @Override
    public TransportProtos.ServiceInfo generateNewServiceInfoWithCurrentSystemInfo() {
        TransportProtos.ServiceInfo.Builder builder = TransportProtos.ServiceInfo.newBuilder().setServiceId(this.serviceId).addAllServiceTypes((Iterable)this.serviceTypes.stream().map(Enum::name).collect(Collectors.toList())).setSystemInfo(this.getCurrentSystemInfoProto());
        if (CollectionsUtil.isNotEmpty(this.assignedTenantProfiles)) {
            builder.addAllAssignedTenantProfiles((Iterable)this.assignedTenantProfiles.stream().map(UUID::toString).collect(Collectors.toList()));
        }
        this.serviceInfo = builder.build();
        return this.serviceInfo;
    }

    private TransportProtos.SystemInfoProto getCurrentSystemInfoProto() {
        TransportProtos.SystemInfoProto.Builder builder = TransportProtos.SystemInfoProto.newBuilder();
        SystemUtil.getCpuUsage().ifPresent(arg_0 -> ((TransportProtos.SystemInfoProto.Builder)builder).setCpuUsage(arg_0));
        SystemUtil.getMemoryUsage().ifPresent(arg_0 -> ((TransportProtos.SystemInfoProto.Builder)builder).setMemoryUsage(arg_0));
        SystemUtil.getDiscSpaceUsage().ifPresent(arg_0 -> ((TransportProtos.SystemInfoProto.Builder)builder).setDiskUsage(arg_0));
        SystemUtil.getCpuCount().ifPresent(arg_0 -> ((TransportProtos.SystemInfoProto.Builder)builder).setCpuCount(arg_0));
        SystemUtil.getTotalMemory().ifPresent(arg_0 -> ((TransportProtos.SystemInfoProto.Builder)builder).setTotalMemory(arg_0));
        SystemUtil.getTotalDiscSpace().ifPresent(arg_0 -> ((TransportProtos.SystemInfoProto.Builder)builder).setTotalDiscSpace(arg_0));
        return builder.build();
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public String getServiceType() {
        return this.serviceType;
    }

    @Override
    public Set<UUID> getAssignedTenantProfiles() {
        return this.assignedTenantProfiles;
    }
}

