/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.common;

import java.util.concurrent.atomic.AtomicInteger;
import org.thingsboard.server.common.msg.queue.RuleEngineException;
import org.thingsboard.server.common.msg.queue.TbMsgCallback;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsgMetadata;

public class MultipleTbQueueTbMsgCallbackWrapper
implements TbQueueCallback {
    private final AtomicInteger tbQueueCallbackCount;
    private final TbMsgCallback tbMsgCallback;

    public MultipleTbQueueTbMsgCallbackWrapper(int tbQueueCallbackCount, TbMsgCallback tbMsgCallback) {
        this.tbQueueCallbackCount = new AtomicInteger(tbQueueCallbackCount);
        this.tbMsgCallback = tbMsgCallback;
    }

    public void onSuccess(TbQueueMsgMetadata metadata) {
        if (this.tbQueueCallbackCount.decrementAndGet() <= 0) {
            this.tbMsgCallback.onSuccess();
        }
    }

    public void onFailure(Throwable t) {
        this.tbMsgCallback.onFailure(new RuleEngineException(t.getMessage(), t));
    }
}

