/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.util;

import java.util.Optional;
import org.nustaq.serialization.FSTConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.FSTUtils;
import org.thingsboard.server.queue.util.DataDecodingEncodingService;

@Service
public class ProtoWithFSTService
implements DataDecodingEncodingService {
    private static final Logger log = LoggerFactory.getLogger(ProtoWithFSTService.class);
    public static final FSTConfiguration CONFIG = FSTConfiguration.createDefaultConfiguration();

    @Override
    public <T> Optional<T> decode(byte[] byteArray) {
        try {
            return Optional.ofNullable(FSTUtils.decode((byte[])byteArray));
        }
        catch (IllegalArgumentException e) {
            log.error("Error during deserialization message, [{}]", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    @Override
    public <T> byte[] encode(T msq) {
        return FSTUtils.encode(msq);
    }
}

