/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.sqs;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@ConditionalOnExpression(value="'${queue.type:null}'=='aws-sqs'")
@Component
public class TbAwsSqsSettings {
    private static final Logger log = LoggerFactory.getLogger(TbAwsSqsSettings.class);
    @Value(value="${queue.aws_sqs.use_default_credential_provider_chain}")
    private Boolean useDefaultCredentialProviderChain;
    @Value(value="${queue.aws_sqs.access_key_id}")
    private String accessKeyId;
    @Value(value="${queue.aws_sqs.secret_access_key}")
    private String secretAccessKey;
    @Value(value="${queue.aws_sqs.region}")
    private String region;
    @Value(value="${queue.aws_sqs.threads_per_topic}")
    private int threadsPerTopic;

    public Boolean getUseDefaultCredentialProviderChain() {
        return this.useDefaultCredentialProviderChain;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public String getRegion() {
        return this.region;
    }

    public int getThreadsPerTopic() {
        return this.threadsPerTopic;
    }

    public void setUseDefaultCredentialProviderChain(Boolean useDefaultCredentialProviderChain) {
        this.useDefaultCredentialProviderChain = useDefaultCredentialProviderChain;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setThreadsPerTopic(int threadsPerTopic) {
        this.threadsPerTopic = threadsPerTopic;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbAwsSqsSettings)) {
            return false;
        }
        TbAwsSqsSettings other = (TbAwsSqsSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getThreadsPerTopic() != other.getThreadsPerTopic()) {
            return false;
        }
        Boolean this$useDefaultCredentialProviderChain = this.getUseDefaultCredentialProviderChain();
        Boolean other$useDefaultCredentialProviderChain = other.getUseDefaultCredentialProviderChain();
        if (this$useDefaultCredentialProviderChain == null ? other$useDefaultCredentialProviderChain != null : !((Object)this$useDefaultCredentialProviderChain).equals(other$useDefaultCredentialProviderChain)) {
            return false;
        }
        String this$accessKeyId = this.getAccessKeyId();
        String other$accessKeyId = other.getAccessKeyId();
        if (this$accessKeyId == null ? other$accessKeyId != null : !this$accessKeyId.equals(other$accessKeyId)) {
            return false;
        }
        String this$secretAccessKey = this.getSecretAccessKey();
        String other$secretAccessKey = other.getSecretAccessKey();
        if (this$secretAccessKey == null ? other$secretAccessKey != null : !this$secretAccessKey.equals(other$secretAccessKey)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        return !(this$region == null ? other$region != null : !this$region.equals(other$region));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbAwsSqsSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getThreadsPerTopic();
        Boolean $useDefaultCredentialProviderChain = this.getUseDefaultCredentialProviderChain();
        result = result * 59 + ($useDefaultCredentialProviderChain == null ? 43 : ((Object)$useDefaultCredentialProviderChain).hashCode());
        String $accessKeyId = this.getAccessKeyId();
        result = result * 59 + ($accessKeyId == null ? 43 : $accessKeyId.hashCode());
        String $secretAccessKey = this.getSecretAccessKey();
        result = result * 59 + ($secretAccessKey == null ? 43 : $secretAccessKey.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        return result;
    }

    public String toString() {
        return "TbAwsSqsSettings(useDefaultCredentialProviderChain=" + this.getUseDefaultCredentialProviderChain() + ", accessKeyId=" + this.getAccessKeyId() + ", secretAccessKey=" + this.getSecretAccessKey() + ", region=" + this.getRegion() + ", threadsPerTopic=" + this.getThreadsPerTopic() + ")";
    }
}

