/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.rabbitmq;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.StringUtils;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='rabbitmq'")
public class TbRabbitMqQueueArguments {
    @Value(value="${queue.rabbitmq.queue-properties.core:}")
    private String coreProperties;
    @Value(value="${queue.rabbitmq.queue-properties.rule-engine:}")
    private String ruleEngineProperties;
    @Value(value="${queue.rabbitmq.queue-properties.transport-api:}")
    private String transportApiProperties;
    @Value(value="${queue.rabbitmq.queue-properties.notifications:}")
    private String notificationsProperties;
    @Value(value="${queue.rabbitmq.queue-properties.js-executor:}")
    private String jsExecutorProperties;
    @Value(value="${queue.rabbitmq.queue-properties.version-control:}")
    private String vcProperties;
    private Map<String, Object> coreArgs;
    private Map<String, Object> ruleEngineArgs;
    private Map<String, Object> transportApiArgs;
    private Map<String, Object> notificationsArgs;
    private Map<String, Object> jsExecutorArgs;
    private Map<String, Object> vcArgs;
    private static final Pattern PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");

    @PostConstruct
    private void init() {
        this.coreArgs = TbRabbitMqQueueArguments.getArgs(this.coreProperties);
        this.ruleEngineArgs = TbRabbitMqQueueArguments.getArgs(this.ruleEngineProperties);
        this.transportApiArgs = TbRabbitMqQueueArguments.getArgs(this.transportApiProperties);
        this.notificationsArgs = TbRabbitMqQueueArguments.getArgs(this.notificationsProperties);
        this.jsExecutorArgs = TbRabbitMqQueueArguments.getArgs(this.jsExecutorProperties);
        this.vcArgs = TbRabbitMqQueueArguments.getArgs(this.vcProperties);
    }

    public static Map<String, Object> getArgs(String properties) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)properties)) {
            for (String property : properties.split(";")) {
                int delimiterPosition = property.indexOf(":");
                String key = property.substring(0, delimiterPosition);
                String strValue = property.substring(delimiterPosition + 1);
                configs.put(key, TbRabbitMqQueueArguments.getObjectValue(strValue));
            }
        }
        return configs;
    }

    private static Object getObjectValue(String str) {
        if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("false")) {
            return Boolean.valueOf(str);
        }
        if (TbRabbitMqQueueArguments.isNumeric(str)) {
            return TbRabbitMqQueueArguments.getNumericValue(str);
        }
        return str;
    }

    private static Object getNumericValue(String str) {
        if (str.contains(".")) {
            return Double.valueOf(str);
        }
        return Long.valueOf(str);
    }

    private static boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        return PATTERN.matcher(strNum).matches();
    }

    public Map<String, Object> getCoreArgs() {
        return this.coreArgs;
    }

    public Map<String, Object> getRuleEngineArgs() {
        return this.ruleEngineArgs;
    }

    public Map<String, Object> getTransportApiArgs() {
        return this.transportApiArgs;
    }

    public Map<String, Object> getNotificationsArgs() {
        return this.notificationsArgs;
    }

    public Map<String, Object> getJsExecutorArgs() {
        return this.jsExecutorArgs;
    }

    public Map<String, Object> getVcArgs() {
        return this.vcArgs;
    }
}

