/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.rabbitmq;

import com.google.gson.Gson;
import com.google.protobuf.InvalidProtocolBufferException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueMsgDecoder;
import org.thingsboard.server.queue.common.AbstractTbQueueConsumerTemplate;
import org.thingsboard.server.queue.common.DefaultTbQueueMsg;
import org.thingsboard.server.queue.rabbitmq.TbRabbitMqSettings;

public class TbRabbitMqConsumerTemplate<T extends TbQueueMsg>
extends AbstractTbQueueConsumerTemplate<GetResponse, T> {
    private static final Logger log = LoggerFactory.getLogger(TbRabbitMqConsumerTemplate.class);
    private final Gson gson = new Gson();
    private final TbQueueAdmin admin;
    private final TbQueueMsgDecoder<T> decoder;
    private final Channel channel;
    private final Connection connection;
    private volatile Set<String> queues;

    public TbRabbitMqConsumerTemplate(TbQueueAdmin admin, TbRabbitMqSettings rabbitMqSettings, String topic, TbQueueMsgDecoder<T> decoder) {
        super(topic);
        this.admin = admin;
        this.decoder = decoder;
        try {
            this.connection = rabbitMqSettings.getConnectionFactory().newConnection();
        }
        catch (IOException | TimeoutException e) {
            log.error("Failed to create connection.", (Throwable)e);
            throw new RuntimeException("Failed to create connection.", e);
        }
        try {
            this.channel = this.connection.createChannel();
        }
        catch (IOException e) {
            log.error("Failed to create chanel.", (Throwable)e);
            throw new RuntimeException("Failed to create chanel.", e);
        }
        this.stopped = false;
    }

    @Override
    protected List<GetResponse> doPoll(long durationInMillis) {
        List<GetResponse> result = this.queues.stream().map(queue -> {
            try {
                return this.channel.basicGet(queue, false);
            }
            catch (IOException e) {
                log.error("Failed to get messages from queue: [{}]", queue);
                throw new RuntimeException("Failed to get messages from queue.", e);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (result.size() > 0) {
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    protected void doSubscribe(List<String> topicNames) {
        this.queues = this.partitions.stream().map(TopicPartitionInfo::getFullTopicName).collect(Collectors.toSet());
        this.queues.forEach(arg_0 -> ((TbQueueAdmin)this.admin).createTopicIfNotExists(arg_0));
    }

    @Override
    protected void doCommit() {
        try {
            this.channel.basicAck(0L, true);
        }
        catch (IOException e) {
            log.error("Failed to ack messages.", (Throwable)e);
        }
    }

    @Override
    protected void doUnsubscribe() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException | TimeoutException e) {
                log.error("Failed to close the channel.");
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                log.error("Failed to close the connection.");
            }
        }
    }

    @Override
    public T decode(GetResponse message) throws InvalidProtocolBufferException {
        DefaultTbQueueMsg msg = (DefaultTbQueueMsg)this.gson.fromJson(new String(message.getBody()), DefaultTbQueueMsg.class);
        return (T)this.decoder.decode((TbQueueMsg)msg);
    }
}

