/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.pubsub;

import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.queue.util.PropertyUtils;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='pubsub'")
public class TbPubSubSubscriptionSettings {
    @Value(value="${queue.pubsub.queue-properties.core:}")
    private String coreProperties;
    @Value(value="${queue.pubsub.queue-properties.rule-engine:}")
    private String ruleEngineProperties;
    @Value(value="${queue.pubsub.queue-properties.transport-api:}")
    private String transportApiProperties;
    @Value(value="${queue.pubsub.queue-properties.notifications:}")
    private String notificationsProperties;
    @Value(value="${queue.pubsub.queue-properties.js-executor:}")
    private String jsExecutorProperties;
    @Value(value="${queue.pubsub.queue-properties.version-control:}")
    private String vcProperties;
    private Map<String, String> coreSettings;
    private Map<String, String> ruleEngineSettings;
    private Map<String, String> transportApiSettings;
    private Map<String, String> notificationsSettings;
    private Map<String, String> jsExecutorSettings;
    private Map<String, String> vcSettings;

    @PostConstruct
    private void init() {
        this.coreSettings = PropertyUtils.getProps(this.coreProperties);
        this.ruleEngineSettings = PropertyUtils.getProps(this.ruleEngineProperties);
        this.transportApiSettings = PropertyUtils.getProps(this.transportApiProperties);
        this.notificationsSettings = PropertyUtils.getProps(this.notificationsProperties);
        this.jsExecutorSettings = PropertyUtils.getProps(this.jsExecutorProperties);
        this.vcSettings = PropertyUtils.getProps(this.vcProperties);
    }

    public Map<String, String> getCoreSettings() {
        return this.coreSettings;
    }

    public Map<String, String> getRuleEngineSettings() {
        return this.ruleEngineSettings;
    }

    public Map<String, String> getTransportApiSettings() {
        return this.transportApiSettings;
    }

    public Map<String, String> getNotificationsSettings() {
        return this.notificationsSettings;
    }

    public Map<String, String> getJsExecutorSettings() {
        return this.jsExecutorSettings;
    }

    public Map<String, String> getVcSettings() {
        return this.vcSettings;
    }
}

