/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.provider;

import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.TbQueueRequestTemplate;
import org.thingsboard.server.queue.common.DefaultTbQueueRequestTemplate;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.provider.TbTransportQueueFactory;
import org.thingsboard.server.queue.rabbitmq.TbRabbitMqAdmin;
import org.thingsboard.server.queue.rabbitmq.TbRabbitMqConsumerTemplate;
import org.thingsboard.server.queue.rabbitmq.TbRabbitMqProducerTemplate;
import org.thingsboard.server.queue.rabbitmq.TbRabbitMqQueueArguments;
import org.thingsboard.server.queue.rabbitmq.TbRabbitMqSettings;
import org.thingsboard.server.queue.settings.TbQueueCoreSettings;
import org.thingsboard.server.queue.settings.TbQueueRuleEngineSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportApiSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportNotificationSettings;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='rabbitmq' && (('${service.type:null}'=='monolith' && '${transport.api_enabled:true}'=='true') || '${service.type:null}'=='tb-transport')")
public class RabbitMqTransportQueueFactory
implements TbTransportQueueFactory {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqTransportQueueFactory.class);
    private final TbQueueTransportApiSettings transportApiSettings;
    private final TbQueueTransportNotificationSettings transportNotificationSettings;
    private final TbRabbitMqSettings rabbitMqSettings;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TbQueueCoreSettings coreSettings;
    private final TbQueueRuleEngineSettings ruleEngineSettings;
    private final TbQueueAdmin coreAdmin;
    private final TbQueueAdmin ruleEngineAdmin;
    private final TbQueueAdmin transportApiAdmin;
    private final TbQueueAdmin notificationAdmin;

    public RabbitMqTransportQueueFactory(TbQueueTransportApiSettings transportApiSettings, TbQueueTransportNotificationSettings transportNotificationSettings, TbRabbitMqSettings rabbitMqSettings, TbServiceInfoProvider serviceInfoProvider, TbQueueCoreSettings coreSettings, TbQueueRuleEngineSettings ruleEngineSettings, TbRabbitMqQueueArguments queueArguments) {
        this.transportApiSettings = transportApiSettings;
        this.transportNotificationSettings = transportNotificationSettings;
        this.rabbitMqSettings = rabbitMqSettings;
        this.serviceInfoProvider = serviceInfoProvider;
        this.coreSettings = coreSettings;
        this.ruleEngineSettings = ruleEngineSettings;
        this.coreAdmin = new TbRabbitMqAdmin(rabbitMqSettings, queueArguments.getCoreArgs());
        this.ruleEngineAdmin = new TbRabbitMqAdmin(rabbitMqSettings, queueArguments.getRuleEngineArgs());
        this.transportApiAdmin = new TbRabbitMqAdmin(rabbitMqSettings, queueArguments.getTransportApiArgs());
        this.notificationAdmin = new TbRabbitMqAdmin(rabbitMqSettings, queueArguments.getNotificationsArgs());
    }

    @Override
    public TbQueueRequestTemplate<TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>, TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>> createTransportApiRequestTemplate() {
        TbRabbitMqProducerTemplate producerTemplate = new TbRabbitMqProducerTemplate(this.transportApiAdmin, this.rabbitMqSettings, this.transportApiSettings.getRequestsTopic());
        TbRabbitMqConsumerTemplate consumerTemplate = new TbRabbitMqConsumerTemplate(this.transportApiAdmin, this.rabbitMqSettings, this.transportApiSettings.getResponsesTopic() + "." + this.serviceInfoProvider.getServiceId(), msg -> new TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>(msg.getKey(), TransportProtos.TransportApiResponseMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
        DefaultTbQueueRequestTemplate.DefaultTbQueueRequestTemplateBuilder templateBuilder = DefaultTbQueueRequestTemplate.builder();
        templateBuilder.queueAdmin(this.transportApiAdmin);
        templateBuilder.requestTemplate(producerTemplate);
        templateBuilder.responseTemplate(consumerTemplate);
        templateBuilder.maxPendingRequests(this.transportApiSettings.getMaxPendingRequests());
        templateBuilder.maxRequestTimeout(this.transportApiSettings.getMaxRequestsTimeout());
        templateBuilder.pollInterval(this.transportApiSettings.getResponsePollInterval());
        return templateBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> createRuleEngineMsgProducer() {
        return new TbRabbitMqProducerTemplate<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>>(this.ruleEngineAdmin, this.rabbitMqSettings, this.ruleEngineSettings.getTopic());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> createTbCoreMsgProducer() {
        return new TbRabbitMqProducerTemplate<TbProtoQueueMsg<TransportProtos.ToCoreMsg>>(this.coreAdmin, this.rabbitMqSettings, this.coreSettings.getTopic());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>> createTbCoreNotificationsMsgProducer() {
        return new TbRabbitMqProducerTemplate<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>>(this.notificationAdmin, this.rabbitMqSettings, this.coreSettings.getTopic());
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> createTransportNotificationsConsumer() {
        return new TbRabbitMqConsumerTemplate<TbProtoQueueMsg<TransportProtos.ToTransportMsg>>(this.notificationAdmin, this.rabbitMqSettings, this.transportNotificationSettings.getNotificationsTopic() + "." + this.serviceInfoProvider.getServiceId(), msg -> new TbProtoQueueMsg<TransportProtos.ToTransportMsg>(msg.getKey(), TransportProtos.ToTransportMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> createToUsageStatsServiceMsgProducer() {
        return new TbRabbitMqProducerTemplate<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>>(this.coreAdmin, this.rabbitMqSettings, this.coreSettings.getUsageStatsTopic());
    }

    @PreDestroy
    private void destroy() {
        if (this.coreAdmin != null) {
            this.coreAdmin.destroy();
        }
        if (this.ruleEngineAdmin != null) {
            this.ruleEngineAdmin.destroy();
        }
        if (this.transportApiAdmin != null) {
            this.transportApiAdmin.destroy();
        }
        if (this.notificationAdmin != null) {
            this.notificationAdmin.destroy();
        }
    }
}

