/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.provider;

import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.nio.charset.StandardCharsets;
import javax.annotation.PreDestroy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.gen.js.JsInvokeProtos;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.TbQueueRequestTemplate;
import org.thingsboard.server.queue.common.DefaultTbQueueRequestTemplate;
import org.thingsboard.server.queue.common.TbProtoJsQueueMsg;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.NotificationsTopicService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.provider.TbCoreQueueFactory;
import org.thingsboard.server.queue.provider.TbRuleEngineQueueFactory;
import org.thingsboard.server.queue.provider.TbVersionControlQueueFactory;
import org.thingsboard.server.queue.settings.TbQueueCoreSettings;
import org.thingsboard.server.queue.settings.TbQueueRemoteJsInvokeSettings;
import org.thingsboard.server.queue.settings.TbQueueRuleEngineSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportApiSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportNotificationSettings;
import org.thingsboard.server.queue.settings.TbQueueVersionControlSettings;
import org.thingsboard.server.queue.sqs.TbAwsSqsAdmin;
import org.thingsboard.server.queue.sqs.TbAwsSqsConsumerTemplate;
import org.thingsboard.server.queue.sqs.TbAwsSqsProducerTemplate;
import org.thingsboard.server.queue.sqs.TbAwsSqsQueueAttributes;
import org.thingsboard.server.queue.sqs.TbAwsSqsSettings;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='aws-sqs' && '${service.type:null}'=='monolith'")
public class AwsSqsMonolithQueueFactory
implements TbCoreQueueFactory,
TbRuleEngineQueueFactory,
TbVersionControlQueueFactory {
    private final NotificationsTopicService notificationsTopicService;
    private final TbQueueCoreSettings coreSettings;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TbQueueRuleEngineSettings ruleEngineSettings;
    private final TbQueueTransportApiSettings transportApiSettings;
    private final TbQueueTransportNotificationSettings transportNotificationSettings;
    private final TbAwsSqsSettings sqsSettings;
    private final TbQueueVersionControlSettings vcSettings;
    private final TbQueueRemoteJsInvokeSettings jsInvokeSettings;
    private final TbQueueAdmin coreAdmin;
    private final TbQueueAdmin ruleEngineAdmin;
    private final TbQueueAdmin jsExecutorAdmin;
    private final TbQueueAdmin transportApiAdmin;
    private final TbQueueAdmin notificationAdmin;
    private final TbQueueAdmin otaAdmin;
    private final TbQueueAdmin vcAdmin;

    public AwsSqsMonolithQueueFactory(NotificationsTopicService notificationsTopicService, TbQueueCoreSettings coreSettings, TbQueueRuleEngineSettings ruleEngineSettings, TbServiceInfoProvider serviceInfoProvider, TbQueueTransportApiSettings transportApiSettings, TbQueueTransportNotificationSettings transportNotificationSettings, TbAwsSqsSettings sqsSettings, TbQueueVersionControlSettings vcSettings, TbAwsSqsQueueAttributes sqsQueueAttributes, TbQueueRemoteJsInvokeSettings jsInvokeSettings) {
        this.notificationsTopicService = notificationsTopicService;
        this.coreSettings = coreSettings;
        this.serviceInfoProvider = serviceInfoProvider;
        this.ruleEngineSettings = ruleEngineSettings;
        this.transportApiSettings = transportApiSettings;
        this.transportNotificationSettings = transportNotificationSettings;
        this.sqsSettings = sqsSettings;
        this.vcSettings = vcSettings;
        this.jsInvokeSettings = jsInvokeSettings;
        this.coreAdmin = new TbAwsSqsAdmin(sqsSettings, sqsQueueAttributes.getCoreAttributes());
        this.ruleEngineAdmin = new TbAwsSqsAdmin(sqsSettings, sqsQueueAttributes.getRuleEngineAttributes());
        this.jsExecutorAdmin = new TbAwsSqsAdmin(sqsSettings, sqsQueueAttributes.getJsExecutorAttributes());
        this.transportApiAdmin = new TbAwsSqsAdmin(sqsSettings, sqsQueueAttributes.getTransportApiAttributes());
        this.notificationAdmin = new TbAwsSqsAdmin(sqsSettings, sqsQueueAttributes.getNotificationsAttributes());
        this.otaAdmin = new TbAwsSqsAdmin(sqsSettings, sqsQueueAttributes.getOtaAttributes());
        this.vcAdmin = new TbAwsSqsAdmin(sqsSettings, sqsQueueAttributes.getVcAttributes());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> createTransportNotificationsMsgProducer() {
        return new TbAwsSqsProducerTemplate<TbProtoQueueMsg<TransportProtos.ToTransportMsg>>(this.notificationAdmin, this.sqsSettings, this.transportNotificationSettings.getNotificationsTopic());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> createRuleEngineMsgProducer() {
        return new TbAwsSqsProducerTemplate<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>>(this.ruleEngineAdmin, this.sqsSettings, this.ruleEngineSettings.getTopic());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>> createRuleEngineNotificationsMsgProducer() {
        return new TbAwsSqsProducerTemplate<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>>(this.notificationAdmin, this.sqsSettings, this.ruleEngineSettings.getTopic());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> createTbCoreMsgProducer() {
        return new TbAwsSqsProducerTemplate<TbProtoQueueMsg<TransportProtos.ToCoreMsg>>(this.coreAdmin, this.sqsSettings, this.coreSettings.getTopic());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>> createTbCoreNotificationsMsgProducer() {
        return new TbAwsSqsProducerTemplate<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>>(this.notificationAdmin, this.sqsSettings, this.coreSettings.getTopic());
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToVersionControlServiceMsg>> createToVersionControlMsgConsumer() {
        return new TbAwsSqsConsumerTemplate<TbProtoQueueMsg<TransportProtos.ToVersionControlServiceMsg>>(this.vcAdmin, this.sqsSettings, this.vcSettings.getTopic(), msg -> new TbProtoQueueMsg<TransportProtos.ToVersionControlServiceMsg>(msg.getKey(), TransportProtos.ToVersionControlServiceMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> createToRuleEngineMsgConsumer(Queue configuration) {
        return new TbAwsSqsConsumerTemplate<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>>(this.ruleEngineAdmin, this.sqsSettings, configuration.getTopic(), msg -> new TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>(msg.getKey(), TransportProtos.ToRuleEngineMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>> createToRuleEngineNotificationsMsgConsumer() {
        return new TbAwsSqsConsumerTemplate<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>>(this.notificationAdmin, this.sqsSettings, this.notificationsTopicService.getNotificationsTopic(ServiceType.TB_RULE_ENGINE, this.serviceInfoProvider.getServiceId()).getFullTopicName(), msg -> new TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>(msg.getKey(), TransportProtos.ToRuleEngineNotificationMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> createToCoreMsgConsumer() {
        return new TbAwsSqsConsumerTemplate<TbProtoQueueMsg<TransportProtos.ToCoreMsg>>(this.coreAdmin, this.sqsSettings, this.coreSettings.getTopic(), msg -> new TbProtoQueueMsg<TransportProtos.ToCoreMsg>(msg.getKey(), TransportProtos.ToCoreMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>> createToCoreNotificationsMsgConsumer() {
        return new TbAwsSqsConsumerTemplate<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>>(this.notificationAdmin, this.sqsSettings, this.notificationsTopicService.getNotificationsTopic(ServiceType.TB_CORE, this.serviceInfoProvider.getServiceId()).getFullTopicName(), msg -> new TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>(msg.getKey(), TransportProtos.ToCoreNotificationMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>> createTransportApiRequestConsumer() {
        return new TbAwsSqsConsumerTemplate<TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>>(this.transportApiAdmin, this.sqsSettings, this.transportApiSettings.getRequestsTopic(), msg -> new TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>(msg.getKey(), TransportProtos.TransportApiRequestMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>> createTransportApiResponseProducer() {
        return new TbAwsSqsProducerTemplate<TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>>(this.transportApiAdmin, this.sqsSettings, this.transportApiSettings.getResponsesTopic());
    }

    @Override
    @Bean
    public TbQueueRequestTemplate<TbProtoJsQueueMsg<JsInvokeProtos.RemoteJsRequest>, TbProtoQueueMsg<JsInvokeProtos.RemoteJsResponse>> createRemoteJsRequestTemplate() {
        TbAwsSqsProducerTemplate producer = new TbAwsSqsProducerTemplate(this.jsExecutorAdmin, this.sqsSettings, this.jsInvokeSettings.getRequestTopic());
        TbAwsSqsConsumerTemplate consumer = new TbAwsSqsConsumerTemplate(this.jsExecutorAdmin, this.sqsSettings, this.jsInvokeSettings.getResponseTopic() + "_" + this.serviceInfoProvider.getServiceId(), msg -> {
            JsInvokeProtos.RemoteJsResponse.Builder builder = JsInvokeProtos.RemoteJsResponse.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(new String(msg.getData(), StandardCharsets.UTF_8), (Message.Builder)builder);
            return new TbProtoQueueMsg<JsInvokeProtos.RemoteJsResponse>(msg.getKey(), builder.build(), msg.getHeaders());
        });
        DefaultTbQueueRequestTemplate.DefaultTbQueueRequestTemplateBuilder builder = DefaultTbQueueRequestTemplate.builder();
        builder.queueAdmin(this.jsExecutorAdmin);
        builder.requestTemplate(producer);
        builder.responseTemplate(consumer);
        builder.maxPendingRequests(this.jsInvokeSettings.getMaxPendingRequests());
        builder.maxRequestTimeout(this.jsInvokeSettings.getMaxRequestsTimeout());
        builder.pollInterval(this.jsInvokeSettings.getResponsePollInterval());
        return builder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> createToUsageStatsServiceMsgProducer() {
        return new TbAwsSqsProducerTemplate<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>>(this.coreAdmin, this.sqsSettings, this.coreSettings.getUsageStatsTopic());
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> createToUsageStatsServiceMsgConsumer() {
        return new TbAwsSqsConsumerTemplate<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>>(this.coreAdmin, this.sqsSettings, this.coreSettings.getUsageStatsTopic(), msg -> new TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>(msg.getKey(), TransportProtos.ToUsageStatsServiceMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>> createToOtaPackageStateServiceMsgConsumer() {
        return new TbAwsSqsConsumerTemplate<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>>(this.otaAdmin, this.sqsSettings, this.coreSettings.getOtaPackageTopic(), msg -> new TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>(msg.getKey(), TransportProtos.ToOtaPackageStateServiceMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>> createToOtaPackageStateServiceMsgProducer() {
        return new TbAwsSqsProducerTemplate<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>>(this.otaAdmin, this.sqsSettings, this.coreSettings.getOtaPackageTopic());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToVersionControlServiceMsg>> createVersionControlMsgProducer() {
        return new TbAwsSqsProducerTemplate<TbProtoQueueMsg<TransportProtos.ToVersionControlServiceMsg>>(this.vcAdmin, this.sqsSettings, this.vcSettings.getTopic());
    }

    @PreDestroy
    private void destroy() {
        if (this.coreAdmin != null) {
            this.coreAdmin.destroy();
        }
        if (this.ruleEngineAdmin != null) {
            this.ruleEngineAdmin.destroy();
        }
        if (this.jsExecutorAdmin != null) {
            this.jsExecutorAdmin.destroy();
        }
        if (this.transportApiAdmin != null) {
            this.transportApiAdmin.destroy();
        }
        if (this.notificationAdmin != null) {
            this.notificationAdmin.destroy();
        }
        if (this.otaAdmin != null) {
            this.otaAdmin.destroy();
        }
        if (this.vcAdmin != null) {
            this.vcAdmin.destroy();
        }
    }
}

