/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.memory.InMemoryStorage;

@Component
public final class DefaultInMemoryStorage
implements InMemoryStorage {
    private static final Logger log = LoggerFactory.getLogger(DefaultInMemoryStorage.class);
    private final ConcurrentHashMap<String, BlockingQueue<TbQueueMsg>> storage = new ConcurrentHashMap();

    @Override
    public void printStats() {
        if (log.isDebugEnabled()) {
            this.storage.forEach((topic, queue) -> {
                if (queue.size() > 0) {
                    log.debug("[{}] Queue Size [{}]", topic, (Object)queue.size());
                }
            });
        }
    }

    @Override
    public int getLagTotal() {
        return this.storage.values().stream().map(Collection::size).reduce(0, Integer::sum);
    }

    @Override
    public boolean put(String topic, TbQueueMsg msg) {
        return this.storage.computeIfAbsent(topic, t -> new LinkedBlockingQueue()).add(msg);
    }

    @Override
    public <T extends TbQueueMsg> List<T> get(String topic) throws InterruptedException {
        TbQueueMsg firstMsg;
        BlockingQueue<TbQueueMsg> queue = this.storage.get(topic);
        if (queue != null && (firstMsg = (TbQueueMsg)queue.poll()) != null) {
            int queueSize = queue.size();
            if (queueSize > 0) {
                ArrayList<TbQueueMsg> entities = new ArrayList<TbQueueMsg>(Math.min(queueSize, 999) + 1);
                entities.add(firstMsg);
                queue.drainTo(entities, 999);
                return entities;
            }
            return Collections.singletonList(firstMsg);
        }
        return Collections.emptyList();
    }
}

