/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.discovery.event;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.queue.discovery.QueueKey;
import org.thingsboard.server.queue.discovery.event.TbApplicationEvent;

public class PartitionChangeEvent
extends TbApplicationEvent {
    private static final long serialVersionUID = -8731788167026510559L;
    private final ServiceType serviceType;
    private final Map<QueueKey, Set<TopicPartitionInfo>> partitionsMap;

    public PartitionChangeEvent(Object source, ServiceType serviceType, Map<QueueKey, Set<TopicPartitionInfo>> partitionsMap) {
        super(source);
        this.serviceType = serviceType;
        this.partitionsMap = partitionsMap;
    }

    public Set<TopicPartitionInfo> getPartitions() {
        return this.partitionsMap.values().stream().findAny().orElse(Collections.emptySet());
    }

    @Override
    public String toString() {
        return "PartitionChangeEvent(super=" + super.toString() + ", serviceType=" + this.getServiceType() + ", partitionsMap=" + this.getPartitionsMap() + ")";
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public Map<QueueKey, Set<TopicPartitionInfo>> getPartitionsMap() {
        return this.partitionsMap;
    }
}

